"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTopNav = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/data-views-plugin/public");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
var _common = require("../../../../../common");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _get_top_nav_links = require("./get_top_nav_links");
var _kibana_services = require("../../../../kibana_services");
var _on_save_search = require("./on_save_search");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverTopNav = ({
  onOpenInspector,
  query,
  savedQuery,
  stateContainer,
  updateQuery,
  searchSource,
  navigateTo,
  savedSearch,
  resetSavedSearch,
  onChangeDataView,
  onDataViewCreated,
  isPlainRecord,
  textBasedLanguageModeErrors,
  onFieldEdited,
  persistDataView,
  updateAdHocDataViewId,
  updateDataViewList
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const adHocDataViews = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.adHocDataViews);
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const savedDataViews = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.savedDataViews);
  const showDatePicker = (0, _react.useMemo)(() => dataView.isTimeBased() && dataView.type !== _public.DataViewType.ROLLUP, [dataView]);
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    dataViewEditor,
    navigation,
    dataViewFieldEditor,
    data,
    uiSettings,
    dataViews
  } = services;
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()) || !dataView.isPersisted();
  const closeFieldEditor = (0, _react.useRef)();
  const closeDataViewEditor = (0, _react.useRef)();
  const {
    AggregateQueryTopNavMenu
  } = navigation.ui;
  const onOpenSavedSearch = (0, _react.useCallback)(newSavedSearchId => {
    if (savedSearch.id && savedSearch.id === newSavedSearchId) {
      resetSavedSearch();
    } else {
      history.push(`/view/${encodeURIComponent(newSavedSearchId)}`);
    }
  }, [history, resetSavedSearch, savedSearch.id]);
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editors when unmounting
      if (closeFieldEditor.current) {
        closeFieldEditor.current();
      }
      if (closeDataViewEditor.current) {
        closeDataViewEditor.current();
      }
    };
  }, []);
  const editField = (0, _react.useMemo)(() => canEditDataView ? async (fieldName, uiAction = 'edit') => {
    if (dataView !== null && dataView !== void 0 && dataView.id) {
      const dataViewInstance = await data.dataViews.get(dataView.id);
      closeFieldEditor.current = dataViewFieldEditor.openEditor({
        ctx: {
          dataView: dataViewInstance
        },
        fieldName,
        onSave: async () => {
          await onFieldEdited();
        }
      });
    }
  } : undefined, [canEditDataView, dataView === null || dataView === void 0 ? void 0 : dataView.id, data.dataViews, dataViewFieldEditor, onFieldEdited]);
  const addField = (0, _react.useMemo)(() => canEditDataView && editField ? () => editField(undefined, 'add') : undefined, [editField, canEditDataView]);
  const createNewDataView = (0, _react.useCallback)(() => {
    closeDataViewEditor.current = dataViewEditor.openEditor({
      onSave: onDataViewCreated,
      allowAdHocDataView: true
    });
  }, [dataViewEditor, onDataViewCreated]);
  const onCreateDefaultAdHocDataView = (0, _react.useCallback)(async pattern => {
    var _newDataView$fields$g;
    const newDataView = await dataViews.create({
      title: pattern
    });
    if (((_newDataView$fields$g = newDataView.fields.getByName('@timestamp')) === null || _newDataView$fields$g === void 0 ? void 0 : _newDataView$fields$g.type) === 'date') {
      newDataView.timeFieldName = '@timestamp';
    }
    stateContainer.actions.appendAdHocDataViews(newDataView);
    onChangeDataView(newDataView.id);
  }, [dataViews, onChangeDataView, stateContainer.actions]);
  const topNavMenu = (0, _react.useMemo)(() => (0, _get_top_nav_links.getTopNavLinks)({
    dataView,
    navigateTo,
    savedSearch,
    services,
    state: stateContainer,
    onOpenInspector,
    searchSource,
    onOpenSavedSearch,
    isPlainRecord,
    adHocDataViews,
    updateDataViewList,
    persistDataView,
    updateAdHocDataViewId
  }), [dataView, navigateTo, savedSearch, services, stateContainer, onOpenInspector, searchSource, onOpenSavedSearch, isPlainRecord, adHocDataViews, persistDataView, updateAdHocDataViewId, updateDataViewList]);
  const onEditDataView = async editedDataView => {
    if (editedDataView.isPersisted()) {
      // Clear the current data view from the cache and create a new instance
      // of it, ensuring we have a new object reference to trigger a re-render
      dataViews.clearInstanceCache(editedDataView.id);
      stateContainer.actions.setDataView(await dataViews.create(editedDataView.toSpec(), true));
    } else {
      await updateAdHocDataViewId(editedDataView);
    }
    stateContainer.actions.loadDataViewList();
    stateContainer.dataState.fetch();
  };
  const updateSavedQueryId = newSavedQueryId => {
    const {
      appState
    } = stateContainer;
    if (newSavedQueryId) {
      appState.update({
        savedQuery: newSavedQueryId
      });
    } else {
      // remove savedQueryId from state
      const newState = {
        ...appState.getState()
      };
      delete newState.savedQuery;
      appState.set(newState);
    }
  };
  const setMenuMountPoint = (0, _react.useMemo)(() => {
    return (0, _kibana_services.getHeaderActionMenuMounter)();
  }, []);
  const isSQLModeEnabled = uiSettings.get(_common.ENABLE_SQL);
  const supportedTextBasedLanguages = [];
  if (isSQLModeEnabled) {
    supportedTextBasedLanguages.push('SQL');
  }
  const dataViewPickerProps = {
    trigger: {
      label: (dataView === null || dataView === void 0 ? void 0 : dataView.getName()) || '',
      'data-test-subj': 'discover-dataView-switch-link',
      title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || ''
    },
    currentDataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
    onAddField: addField,
    onDataViewCreated: createNewDataView,
    onCreateDefaultAdHocDataView,
    onChangeDataView,
    textBasedLanguages: supportedTextBasedLanguages,
    adHocDataViews,
    savedDataViews,
    onEditDataView
  };
  const onTextBasedSavedAndExit = (0, _react.useCallback)(({
    onSave,
    onCancel
  }) => {
    (0, _on_save_search.onSaveSearch)({
      savedSearch,
      services,
      dataView,
      navigateTo,
      state: stateContainer,
      onClose: onCancel,
      onSaveCb: onSave,
      updateAdHocDataViewId
    });
  }, [dataView, navigateTo, savedSearch, services, stateContainer, updateAdHocDataViewId]);
  return /*#__PURE__*/_react.default.createElement(AggregateQueryTopNavMenu, {
    appName: "discover",
    config: topNavMenu,
    indexPatterns: [dataView],
    onQuerySubmit: updateQuery,
    onSavedQueryIdChange: updateSavedQueryId,
    query: query,
    setMenuMountPoint: setMenuMountPoint,
    savedQueryId: savedQuery,
    screenTitle: savedSearch.title,
    showDatePicker: showDatePicker,
    showSaveQuery: !isPlainRecord && Boolean(services.capabilities.discover.saveQuery),
    showSearchBar: true,
    useDefaultBehaviors: true,
    dataViewPickerComponentProps: dataViewPickerProps,
    displayStyle: "detached",
    textBasedLanguageModeErrors: textBasedLanguageModeErrors ? [textBasedLanguageModeErrors] : undefined,
    onTextBasedSavedAndExit: onTextBasedSavedAndExit
  });
};
exports.DiscoverTopNav = DiscoverTopNav;