"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INITIAL_SELECTED_FIELDS_RESULT = void 0;
exports.getSelectedFields = getSelectedFields;
exports.shouldShowField = shouldShowField;
var _lodash = require("lodash");
var _public = require("@kbn/data-views-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function shouldShowField(field, isPlainRecord) {
  if (!(field !== null && field !== void 0 && field.type) || field.type === '_source') {
    return false;
  }
  if (isPlainRecord) {
    // exclude only `_source` for plain records
    return true;
  }
  // exclude subfields
  return !(0, _public.getFieldSubtypeMulti)(field === null || field === void 0 ? void 0 : field.spec);
}

// to avoid rerenderings for empty state
const INITIAL_SELECTED_FIELDS_RESULT = {
  selectedFields: [],
  selectedFieldsMap: {}
};
exports.INITIAL_SELECTED_FIELDS_RESULT = INITIAL_SELECTED_FIELDS_RESULT;
function getSelectedFields({
  dataView,
  columns,
  allFields,
  isPlainRecord
}) {
  const result = {
    selectedFields: [],
    selectedFieldsMap: {}
  };
  if (!Array.isArray(columns) || !columns.length || !allFields) {
    return INITIAL_SELECTED_FIELDS_RESULT;
  }

  // add selected columns, that are not part of the data view, to be removable
  for (const column of columns) {
    var _dataView$getFieldByN;
    const selectedField = !isPlainRecord && (dataView === null || dataView === void 0 ? void 0 : (_dataView$getFieldByN = dataView.getFieldByName) === null || _dataView$getFieldByN === void 0 ? void 0 : _dataView$getFieldByN.call(dataView, column)) || allFields.find(field => field.name === column) ||
    // for example to pick a `nested` root field or find a selected field in text-based response
    {
      name: column,
      displayName: column,
      type: 'unknown_selected'
    };
    result.selectedFields.push(selectedField);
    result.selectedFieldsMap[selectedField.name] = true;
  }
  result.selectedFields = (0, _lodash.uniqBy)(result.selectedFields, 'name');
  if (result.selectedFields.length === 1 && result.selectedFields[0].name === '_source') {
    return INITIAL_SELECTED_FIELDS_RESULT;
  }
  return result;
}