"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSidebarResponsive = DiscoverSidebarResponsive;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-field-list-plugin/public");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _discover_sidebar = require("./discover_sidebar");
var _discover_data_state_container = require("../../services/discover_data_state_container");
var _calc_field_counts = require("../../utils/calc_field_counts");
var _types = require("../../../types");
var _discover_tour = require("../../../../components/discover_tour");
var _get_raw_record_type = require("../../utils/get_raw_record_type");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _sidebar_reducer = require("./lib/sidebar_reducer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMPTY_FIELD_COUNTS = {};
/**
 * Component providing 2 different renderings for the sidebar depending on available screen space
 * Desktop: Sidebar view, all elements are visible
 * Mobile: Data view selector is visible and a button to trigger a flyout with all elements
 */
function DiscoverSidebarResponsive(props) {
  var _querySubscriberResul;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    data,
    dataViews,
    core
  } = services;
  const isPlainRecord = (0, _discover_app_state_container.useAppStateSelector)(state => (0, _get_raw_record_type.getRawRecordType)(state.query) === _discover_data_state_container.RecordRawType.PLAIN);
  const {
    selectedDataView,
    onFieldEdited,
    onDataViewCreated
  } = props;
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [sidebarState, dispatchSidebarStateAction] = (0, _react.useReducer)(_sidebar_reducer.discoverSidebarReducer, selectedDataView, _sidebar_reducer.getInitialState);
  const selectedDataViewRef = (0, _react.useRef)(selectedDataView);
  const showFieldList = sidebarState.status !== _sidebar_reducer.DiscoverSidebarReducerStatus.INITIAL;
  (0, _react.useEffect)(() => {
    const subscription = props.documents$.subscribe(documentState => {
      const isPlainRecordType = documentState.recordRawType === _discover_data_state_container.RecordRawType.PLAIN;
      switch (documentState === null || documentState === void 0 ? void 0 : documentState.fetchStatus) {
        case _types.FetchStatus.UNINITIALIZED:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.RESET,
            payload: {
              dataView: selectedDataViewRef.current
            }
          });
          break;
        case _types.FetchStatus.LOADING:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.DOCUMENTS_LOADING,
            payload: {
              isPlainRecord: isPlainRecordType
            }
          });
          break;
        case _types.FetchStatus.COMPLETE:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.DOCUMENTS_LOADED,
            payload: {
              dataView: selectedDataViewRef.current,
              fieldCounts: isPlainRecordType ? EMPTY_FIELD_COUNTS : (0, _calc_field_counts.calcFieldCounts)(documentState.result),
              textBasedQueryColumns: documentState.textBasedQueryColumns,
              isPlainRecord: isPlainRecordType
            }
          });
          break;
        case _types.FetchStatus.ERROR:
          dispatchSidebarStateAction({
            type: _sidebar_reducer.DiscoverSidebarReducerActionType.DOCUMENTS_LOADED,
            payload: {
              dataView: selectedDataViewRef.current,
              fieldCounts: EMPTY_FIELD_COUNTS,
              isPlainRecord: isPlainRecordType
            }
          });
          break;
        default:
          break;
      }
    });
    return () => subscription.unsubscribe();
  }, [props.documents$, dispatchSidebarStateAction, selectedDataViewRef]);
  (0, _react.useEffect)(() => {
    if (selectedDataView !== selectedDataViewRef.current) {
      dispatchSidebarStateAction({
        type: _sidebar_reducer.DiscoverSidebarReducerActionType.DATA_VIEW_SWITCHED,
        payload: {
          dataView: selectedDataView
        }
      });
      selectedDataViewRef.current = selectedDataView;
    }
  }, [selectedDataView, dispatchSidebarStateAction, selectedDataViewRef]);
  const querySubscriberResult = (0, _public.useQuerySubscriber)({
    data
  });
  const isAffectedByGlobalFilter = Boolean((_querySubscriberResul = querySubscriberResult.filters) === null || _querySubscriberResul === void 0 ? void 0 : _querySubscriberResul.length);
  const {
    isProcessing,
    refetchFieldsExistenceInfo
  } = (0, _public.useExistingFieldsFetcher)({
    disableAutoFetching: true,
    dataViews: !isPlainRecord && sidebarState.dataView ? [sidebarState.dataView] : [],
    query: querySubscriberResult.query,
    filters: querySubscriberResult.filters,
    fromDate: querySubscriberResult.fromDate,
    toDate: querySubscriberResult.toDate,
    services: {
      data,
      dataViews,
      core
    }
  });
  (0, _react.useEffect)(() => {
    if (sidebarState.status === _sidebar_reducer.DiscoverSidebarReducerStatus.COMPLETED) {
      refetchFieldsExistenceInfo();
    }
    // refetching only if status changes
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [sidebarState.status]);
  const closeFieldEditor = (0, _react.useRef)();
  const closeDataViewEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    const cleanup = () => {
      if (closeFieldEditor !== null && closeFieldEditor !== void 0 && closeFieldEditor.current) {
        closeFieldEditor === null || closeFieldEditor === void 0 ? void 0 : closeFieldEditor.current();
      }
      if (closeDataViewEditor !== null && closeDataViewEditor !== void 0 && closeDataViewEditor.current) {
        closeDataViewEditor === null || closeDataViewEditor === void 0 ? void 0 : closeDataViewEditor.current();
      }
    };
    return () => {
      // Make sure to close the editor when unmounting
      cleanup();
    };
  }, []);
  const setFieldEditorRef = (0, _react.useCallback)(ref => {
    closeFieldEditor.current = ref;
  }, []);
  const setDataViewEditorRef = (0, _react.useCallback)(ref => {
    closeDataViewEditor.current = ref;
  }, []);
  const closeFlyout = (0, _react.useCallback)(() => {
    setIsFlyoutVisible(false);
  }, []);
  const {
    dataViewFieldEditor,
    dataViewEditor
  } = services;
  const {
    availableFields$
  } = props;
  const canEditDataView = Boolean(dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView()) || !(selectedDataView !== null && selectedDataView !== void 0 && selectedDataView.isPersisted());
  (0, _react.useEffect)(() => {
    // For an external embeddable like the Field stats
    // it is useful to know what fields are populated in the docs fetched
    // or what fields are selected by the user

    const availableFields = props.columns.length > 0 ? props.columns : Object.keys(sidebarState.fieldCounts || {});
    availableFields$.next({
      fetchStatus: _types.FetchStatus.COMPLETE,
      fields: availableFields
    });
  }, [selectedDataView, sidebarState.fieldCounts, props.columns, availableFields$]);
  const editField = (0, _react.useMemo)(() => !isPlainRecord && canEditDataView && selectedDataView ? fieldName => {
    const ref = dataViewFieldEditor.openEditor({
      ctx: {
        dataView: selectedDataView
      },
      fieldName,
      onSave: async () => {
        await onFieldEdited();
      }
    });
    if (setFieldEditorRef) {
      setFieldEditorRef(ref);
    }
    if (closeFlyout) {
      closeFlyout();
    }
  } : undefined, [isPlainRecord, canEditDataView, dataViewFieldEditor, selectedDataView, setFieldEditorRef, closeFlyout, onFieldEdited]);
  const createNewDataView = (0, _react.useCallback)(() => {
    const ref = dataViewEditor.openEditor({
      onSave: async dataView => {
        onDataViewCreated(dataView);
      }
    });
    if (setDataViewEditorRef) {
      setDataViewEditorRef(ref);
    }
    if (closeFlyout) {
      closeFlyout();
    }
  }, [dataViewEditor, setDataViewEditorRef, closeFlyout, onDataViewCreated]);
  if (!selectedDataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !props.isClosed && /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's']
  }, /*#__PURE__*/_react.default.createElement(_discover_sidebar.DiscoverSidebar, (0, _extends2.default)({}, props, {
    isProcessing: isProcessing,
    onFieldEdited: onFieldEdited,
    allFields: sidebarState.allFields,
    editField: editField,
    createNewDataView: createNewDataView,
    showFieldList: showFieldList,
    isAffectedByGlobalFilter: isAffectedByGlobalFilter
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['xs', 's']
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dscSidebar__mobile"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    contentProps: {
      className: 'dscSidebar__mobileButton',
      id: _discover_tour.DISCOVER_TOUR_STEP_ANCHOR_IDS.addFields
    },
    fullWidth: true,
    onClick: () => setIsFlyoutVisible(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.fieldChooser.fieldsMobileButtonLabel",
    defaultMessage: "Fields"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "dscSidebar__mobileBadge",
    color: props.columns[0] === '_source' ? 'default' : 'accent'
  }, props.columns[0] === '_source' ? 0 : props.columns.length))), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "s",
    onClose: () => setIsFlyoutVisible(false),
    "aria-labelledby": "flyoutTitle",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "text",
    onClick: () => setIsFlyoutVisible(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "eui-alignBaseline",
    "aria-label": _i18n.i18n.translate('discover.fieldList.flyoutBackIcon', {
      defaultMessage: 'Back'
    }),
    type: "arrowLeft"
  }), ' ', /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('discover.fieldList.flyoutHeading', {
    defaultMessage: 'Field list'
  })))))), /*#__PURE__*/_react.default.createElement(_discover_sidebar.DiscoverSidebar, (0, _extends2.default)({}, props, {
    isProcessing: isProcessing,
    onFieldEdited: onFieldEdited,
    allFields: sidebarState.allFields,
    alwaysShowActionButtons: true,
    setFieldEditorRef: setFieldEditorRef,
    closeFlyout: closeFlyout,
    editField: editField,
    createNewDataView: createNewDataView,
    showDataViewPicker: true,
    showFieldList: showFieldList,
    isAffectedByGlobalFilter: isAffectedByGlobalFilter
  }))))));
}