"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StringFieldProgressBar = StringFieldProgressBar;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function StringFieldProgressBar({
  value,
  percent,
  count
}) {
  const ariaLabel = `${value}: ${count} (${percent}%)`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: percent,
    max: 100,
    color: "success",
    "aria-label": ariaLabel,
    size: "s"
  });
}