"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDetails = getDetails;
exports.isValidFieldDetails = void 0;
var _field_calculator = require("./field_calculator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isValidFieldDetails = details => !details.error;
exports.isValidFieldDetails = isValidFieldDetails;
function getDetails(field, hits, dataView) {
  if (!hits) {
    return undefined;
  }
  return _field_calculator.fieldCalculator.getFieldValueCounts({
    hits,
    field,
    count: 5,
    grouped: false,
    dataView
  });
}