"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverFieldDetails = DiscoverFieldDetails;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _discover_field_bucket = require("./discover_field_bucket");
var _get_details = require("./get_details");
var _types = require("../../../../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DiscoverFieldDetails({
  documents$,
  field,
  dataView,
  onAddFilter
}) {
  const [detailsState, setDetailsState] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const subscription = documents$.subscribe(data => {
      if (data.fetchStatus === _types.FetchStatus.COMPLETE) {
        setDetailsState({
          details: (0, _get_details.getDetails)(field, data.result, dataView),
          loaded: true
        });
      } else {
        setDetailsState({
          details: undefined,
          loaded: data.fetchStatus !== _types.FetchStatus.LOADING
        });
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [documents$, setDetailsState, dataView, field]);
  if (!(detailsState !== null && detailsState !== void 0 && detailsState.loaded)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  const details = detailsState === null || detailsState === void 0 ? void 0 : detailsState.details;
  if (!details) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `discoverFieldDetails-${field.name}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('discover.fieldChooser.discoverField.fieldTopValuesLabel', {
    defaultMessage: 'Top 5 values'
  }))), !(0, _get_details.isValidFieldDetails)(details) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, details.error), (0, _get_details.isValidFieldDetails)(details) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: '4px'
    }
  }, details.buckets.map((bucket, idx) => /*#__PURE__*/_react.default.createElement(_discover_field_bucket.DiscoverFieldBucket, {
    key: `bucket${idx}`,
    bucket: bucket,
    field: field,
    onAddFilter: onAddFilter
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, onAddFilter && !dataView.metaFields.includes(field.name) && !field.scripted ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => onAddFilter('_exists_', field.name, '+'),
    "data-test-subj": "onAddFilterButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.fieldChooser.detailViews.existsInRecordsText",
    defaultMessage: "Exists in {value} / {totalValue} records",
    values: {
      value: details.exists,
      totalValue: details.total
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.fieldChooser.detailViews.valueOfRecordsText",
    defaultMessage: "{value} / {totalValue} records",
    values: {
      value: details.exists,
      totalValue: details.total
    }
  }))));
}