"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverFieldBucket = DiscoverFieldBucket;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _string_progress_bar = require("./string_progress_bar");
require("./discover_field_bucket.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DiscoverFieldBucket({
  field,
  bucket,
  onAddFilter
}) {
  const emptyTxt = _i18n.i18n.translate('discover.fieldChooser.detailViews.emptyStringText', {
    defaultMessage: 'Empty string'
  });
  const addLabel = _i18n.i18n.translate('discover.fieldChooser.detailViews.filterValueButtonAriaLabel', {
    defaultMessage: 'Filter for {field}: "{value}"',
    values: {
      value: bucket.value,
      field: field.name
    }
  });
  const removeLabel = _i18n.i18n.translate('discover.fieldChooser.detailViews.filterOutValueButtonAriaLabel', {
    defaultMessage: 'Filter out {field}: "{value}"',
    values: {
      value: bucket.value,
      field: field.name
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "dscFieldDetails__barContainer",
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    title: bucket.display === '' ? emptyTxt : `${bucket.display}: ${bucket.count} (${bucket.percent}%)`,
    size: "xs",
    className: "eui-textTruncate"
  }, bucket.display === '' ? emptyTxt : bucket.display)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    size: "xs",
    className: "eui-textTruncate"
  }, bucket.percent, "%"))), /*#__PURE__*/_react.default.createElement(_string_progress_bar.StringFieldProgressBar, {
    value: bucket.value,
    percent: bucket.percent,
    count: bucket.count
  })), onAddFilter && field.filterable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconSize: "s",
    iconType: "plusInCircle",
    onClick: () => onAddFilter(field, bucket.value, '+'),
    "aria-label": addLabel,
    "data-test-subj": `plus-${field.name}-${bucket.value}`,
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingRight: 2,
      paddingLeft: 2,
      paddingTop: 0,
      paddingBottom: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconSize: "s",
    iconType: "minusInCircle",
    onClick: () => onAddFilter(field, bucket.value, '-'),
    "aria-label": removeLabel,
    "data-test-subj": `minus-${field.name}-${bucket.value}`,
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingTop: 0,
      paddingBottom: 0,
      paddingRight: 2,
      paddingLeft: 2
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
}