"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsSuggestions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18nReact = require("@kbn/i18n-react");
var _no_results_suggestion_default = require("./no_results_suggestion_default");
var _no_results_suggestion_when_filters = require("./no_results_suggestion_when_filters");
var _no_results_suggestion_when_query = require("./no_results_suggestion_when_query");
var _no_results_suggestion_when_time_range = require("./no_results_suggestion_when_time_range");
var _utils = require("../../layout/utils");
var _use_discover_services = require("../../../../../hooks/use_discover_services");
var _use_fetch_occurances_range = require("./use_fetch_occurances_range");
var _no_results_illustration = require("./assets/no_results_illustration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NoResultsSuggestions = ({
  dataView,
  isTimeBased,
  query,
  filters,
  onDisableFilters
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    data,
    uiSettings,
    timefilter
  } = services;
  const hasQuery = (0, _esQuery.isOfQueryType)(query) && !!(query !== null && query !== void 0 && query.query) || !!query && (0, _esQuery.isOfAggregateQueryType)(query);
  const hasFilters = (0, _utils.hasActiveFilter)(filters);
  const [isExtending, setIsExtending] = (0, _react.useState)(false);
  const {
    range: occurrencesRange,
    refetch
  } = (0, _use_fetch_occurances_range.useFetchOccurrencesRange)({
    dataView,
    query,
    filters,
    services: {
      data,
      uiSettings
    }
  });
  const extendTimeRange = async () => {
    setIsExtending(true);
    const range = await refetch();
    if (range !== null && range !== void 0 && range.from && range !== null && range !== void 0 && range.to) {
      timefilter.setTime({
        from: range.from,
        to: range.to
      });
    } else {
      setIsExtending(false);
    }
  };
  const canExtendTimeRange = Boolean((occurrencesRange === null || occurrencesRange === void 0 ? void 0 : occurrencesRange.from) && occurrencesRange.to);
  const canAdjustSearchCriteria = isTimeBased || hasFilters || hasQuery;
  const body = canAdjustSearchCriteria ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.tryText",
    defaultMessage: "Here are some things to try:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("ul", {
    css: (0, _react2.css)`
          display: inline-block;
        `
  }, isTimeBased && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_no_results_suggestion_when_time_range.NoResultsSuggestionWhenTimeRange, null)), hasQuery && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_no_results_suggestion_when_query.NoResultsSuggestionWhenQuery, {
    querySyntax: (0, _esQuery.isOfQueryType)(query) ? query.language : undefined
  })), hasFilters && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_no_results_suggestion_when_filters.NoResultsSuggestionWhenFilters, {
    onDisableFilters: onDisableFilters
  })))) : /*#__PURE__*/_react.default.createElement(_no_results_suggestion_default.NoResultsSuggestionDefault, {
    dataView: dataView
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    layout: "horizontal",
    color: "plain",
    icon: /*#__PURE__*/_react.default.createElement(_no_results_illustration.NoResultsIllustration, null),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "discoverNoResults"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noResults.searchExamples.noResultsMatchSearchCriteriaTitle",
      defaultMessage: "No results match your search\xA0criteria"
    })),
    body: body,
    actions: /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
            min-block-size: ${euiTheme.size.xxl};
          `
    }, typeof occurrencesRange === 'undefined' ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : canExtendTimeRange ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: extendTimeRange,
      isLoading: isExtending,
      "data-test-subj": "discoverNoResultsViewAllMatches"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noResults.suggestion.viewAllMatchesButtonText",
      defaultMessage: "View all matches"
    })) : null)
  });
};
exports.NoResultsSuggestions = NoResultsSuggestions;