"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverNoResults = DiscoverNoResults;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _no_results_suggestions = require("./no_results_suggestions");
require("./_no_results.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DiscoverNoResults({
  isTimeBased,
  query,
  filters,
  dataView,
  onDisableFilters
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_no_results_suggestions.NoResultsSuggestions, {
    isTimeBased: isTimeBased,
    query: query,
    filters: filters,
    dataView: dataView,
    onDisableFilters: onDisableFilters
  })));
}