"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverHistogram = void 0;
var _public = require("@kbn/unified-field-list-plugin/public");
var _public2 = require("@kbn/unified-histogram-plugin/public");
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _kibana_services = require("../../../../kibana_services");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _use_saved_search_messages = require("../../hooks/use_saved_search_messages");
var _add_log = require("../../../../utils/add_log");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useDiscoverHistogram = ({
  stateContainer,
  inspectorAdapters,
  hideChart,
  isPlainRecord
}) => {
  var _savedSearchData$$doc, _savedSearchData$$doc2;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const savedSearchData$ = stateContainer.dataState.data$;

  /**
   * API initialization
   */

  const [unifiedHistogram, ref] = (0, _react.useState)();
  const getCreationOptions = (0, _react.useCallback)(() => {
    const {
      hideChart: chartHidden,
      interval: timeInterval,
      breakdownField
    } = stateContainer.appState.getState();
    const {
      fetchStatus: totalHitsStatus,
      result: totalHitsResult
    } = savedSearchData$.totalHits$.getValue();
    return {
      localStorageKeyPrefix: 'discover',
      disableAutoFetching: true,
      initialState: {
        chartHidden,
        timeInterval,
        breakdownField,
        totalHitsStatus: totalHitsStatus.toString(),
        totalHitsResult
      }
    };
  }, [savedSearchData$.totalHits$, stateContainer.appState]);

  /**
   * Sync Unified Histogram state with Discover state
   */

  (0, _react.useEffect)(() => {
    var _createUnifiedHistogr;
    const subscription = (_createUnifiedHistogr = createUnifiedHistogramStateObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createUnifiedHistogr === void 0 ? void 0 : _createUnifiedHistogr.subscribe(changes => {
      const {
        lensRequestAdapter,
        ...stateChanges
      } = changes;
      const appState = stateContainer.appState.getState();
      const oldState = {
        hideChart: appState.hideChart,
        interval: appState.interval,
        breakdownField: appState.breakdownField
      };
      const newState = {
        ...oldState,
        ...stateChanges
      };
      if ('lensRequestAdapter' in changes) {
        inspectorAdapters.lensRequests = lensRequestAdapter;
      }
      if (!(0, _lodash.isEqual)(oldState, newState)) {
        stateContainer.appState.update(newState);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [inspectorAdapters, stateContainer.appState, unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$]);

  /**
   * Override Unified Histgoram total hits with Discover partial results
   */

  const firstLoadComplete = (0, _react.useRef)(false);
  const {
    fetchStatus: totalHitsStatus,
    result: totalHitsResult
  } = (0, _use_data_state.useDataState)(savedSearchData$.totalHits$);
  (0, _react.useEffect)(() => {
    // We only want to show the partial results on the first load,
    // or there will be a flickering effect as the loading spinner
    // is quickly shown and hidden again on fetches
    if (!firstLoadComplete.current) {
      unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setTotalHits({
        totalHitsStatus: totalHitsStatus.toString(),
        totalHitsResult
      });
    }
  }, [totalHitsResult, totalHitsStatus, unifiedHistogram]);

  /**
   * Sync URL query params with Unified Histogram
   */

  (0, _react.useEffect)(() => {
    const subscription = createAppStateObservable(stateContainer.appState.state$).subscribe(changes => {
      if ('breakdownField' in changes) {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setBreakdownField(changes.breakdownField);
      }
      if ('timeInterval' in changes && changes.timeInterval) {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setTimeInterval(changes.timeInterval);
      }
      if ('chartHidden' in changes && typeof changes.chartHidden === 'boolean') {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setChartHidden(changes.chartHidden);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [stateContainer.appState.state$, unifiedHistogram]);

  /**
   * Columns
   */

  // Update the columns only when documents are fetched so the Lens suggestions
  // don't constantly change when the user modifies the table columns
  const columnsObservable = (0, _react.useMemo)(() => createColumnsObservable(savedSearchData$.documents$), [savedSearchData$.documents$]);
  const columns = (0, _useObservable.default)(columnsObservable, (_savedSearchData$$doc = (_savedSearchData$$doc2 = savedSearchData$.documents$.getValue().textBasedQueryColumns) === null || _savedSearchData$$doc2 === void 0 ? void 0 : _savedSearchData$$doc2.map(({
    name
  }) => name)) !== null && _savedSearchData$$doc !== void 0 ? _savedSearchData$$doc : []);

  /**
   * Total hits
   */

  const setTotalHitsError = (0, _react.useMemo)(() => (0, _use_saved_search_messages.sendErrorTo)(savedSearchData$.totalHits$), [savedSearchData$.totalHits$]);
  (0, _react.useEffect)(() => {
    var _createTotalHitsObser;
    const subscription = (_createTotalHitsObser = createTotalHitsObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createTotalHitsObser === void 0 ? void 0 : _createTotalHitsObser.subscribe(({
      status,
      result
    }) => {
      if (result instanceof Error) {
        // Set totalHits$ to an error state
        setTotalHitsError(result);
        return;
      }
      const {
        recordRawType
      } = savedSearchData$.totalHits$.getValue();

      // Sync the totalHits$ observable with the unified histogram state
      savedSearchData$.totalHits$.next({
        fetchStatus: status.toString(),
        result,
        recordRawType
      });
      if (status !== _public2.UnifiedHistogramFetchStatus.complete || typeof result !== 'number') {
        return;
      }

      // Check the hits count to set a partial or no results state
      (0, _use_saved_search_messages.checkHitCount)(savedSearchData$.main$, result);

      // Indicate the first load has completed so we don't show
      // partial results on subsequent fetches
      firstLoadComplete.current = true;
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [savedSearchData$.main$, savedSearchData$.totalHits$, setTotalHitsError, unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$]);

  /**
   * Request params
   */
  const {
    query,
    filters
  } = (0, _public.useQuerySubscriber)({
    data: services.data
  });
  const timefilter = services.data.query.timefilter.timefilter;
  const timeRange = timefilter.getAbsoluteTime();
  const relativeTimeRange = (0, _useObservable.default)(timefilter.getTimeUpdate$().pipe((0, _rxjs.map)(() => timefilter.getTime())), timefilter.getTime());

  /**
   * Data fetching
   */

  const savedSearchFetch$ = stateContainer.dataState.fetch$;
  const skipDiscoverRefetch = (0, _react.useRef)();
  const skipLensSuggestionRefetch = (0, _react.useRef)();
  const usingLensSuggestion = (0, _useLatest.default)(isPlainRecord && !hideChart);

  // Skip refetching when showing the chart since Lens will
  // automatically fetch when the chart is shown
  (0, _react.useEffect)(() => {
    if (skipDiscoverRefetch.current === undefined) {
      skipDiscoverRefetch.current = false;
    } else {
      skipDiscoverRefetch.current = !hideChart;
    }
  }, [hideChart]);

  // Trigger a unified histogram refetch when savedSearchFetch$ is triggered
  (0, _react.useEffect)(() => {
    const subscription = savedSearchFetch$.subscribe(() => {
      if (!skipDiscoverRefetch.current) {
        (0, _add_log.addLog)('Unified Histogram - Discover refetch');
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.refetch();
      }
      skipDiscoverRefetch.current = false;
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [savedSearchFetch$, unifiedHistogram, usingLensSuggestion]);

  // Reload the chart when the current suggestion changes
  const [currentSuggestion, setCurrentSuggestion] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (!skipLensSuggestionRefetch.current && currentSuggestion && usingLensSuggestion.current) {
      (0, _add_log.addLog)('Unified Histogram - Lens suggestion refetch');
      unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.refetch();
    }
    skipLensSuggestionRefetch.current = false;
  }, [currentSuggestion, unifiedHistogram, usingLensSuggestion]);
  (0, _react.useEffect)(() => {
    var _createCurrentSuggest;
    const subscription = (_createCurrentSuggest = createCurrentSuggestionObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createCurrentSuggest === void 0 ? void 0 : _createCurrentSuggest.subscribe(setCurrentSuggestion);
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [unifiedHistogram]);

  // When the data view or query changes, which will trigger a current suggestion change,
  // skip the next refetch since we want to wait for the columns to update first, which
  // doesn't happen until after the documents are fetched
  const dataViewId = (0, _discover_internal_state_container.useInternalStateSelector)(state => {
    var _state$dataView;
    return (_state$dataView = state.dataView) === null || _state$dataView === void 0 ? void 0 : _state$dataView.id;
  });
  const skipFetchParams = (0, _react.useRef)({
    dataViewId,
    query
  });
  (0, _react.useEffect)(() => {
    const newSkipFetchParams = {
      dataViewId,
      query
    };
    if ((0, _lodash.isEqual)(skipFetchParams.current, newSkipFetchParams)) {
      return;
    }
    skipFetchParams.current = newSkipFetchParams;
    if (usingLensSuggestion.current) {
      skipLensSuggestionRefetch.current = true;
      skipDiscoverRefetch.current = true;
    }
  }, [dataViewId, query, usingLensSuggestion]);
  return {
    ref,
    getCreationOptions,
    services: {
      ...services,
      uiActions: (0, _kibana_services.getUiActions)()
    },
    query,
    filters,
    timeRange,
    relativeTimeRange,
    columns
  };
};

// Use pairwise to diff the previous and current state (starting with undefined to ensure
// pairwise triggers after a single emission), and return an object containing only the
// changed properties. By only including the changed properties, we avoid accidentally
// overwriting other state properties that may have been updated between the time this
// obersverable was triggered and the time the state changes are applied.
exports.useDiscoverHistogram = useDiscoverHistogram;
const createUnifiedHistogramStateObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.lensRequestAdapter) !== curr.lensRequestAdapter) {
      changes.lensRequestAdapter = curr.lensRequestAdapter;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.chartHidden) !== curr.chartHidden) {
      changes.hideChart = curr.chartHidden;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.timeInterval) !== curr.timeInterval) {
      changes.interval = curr.timeInterval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.breakdownField) !== curr.breakdownField) {
      changes.breakdownField = curr.breakdownField;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createAppStateObservable = state$ => {
  return state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.breakdownField) !== curr.breakdownField) {
      changes.breakdownField = curr.breakdownField;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.interval) !== curr.interval) {
      changes.timeInterval = curr.interval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.hideChart) !== curr.hideChart) {
      changes.chartHidden = curr.hideChart;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createColumnsObservable = documents$ => {
  return documents$.pipe((0, _rxjs.distinctUntilChanged)((prev, curr) => prev.fetchStatus === curr.fetchStatus), (0, _rxjs.filter)(({
    fetchStatus
  }) => fetchStatus === _types.FetchStatus.COMPLETE), (0, _rxjs.map)(({
    textBasedQueryColumns
  }) => {
    var _textBasedQueryColumn;
    return (_textBasedQueryColumn = textBasedQueryColumns === null || textBasedQueryColumns === void 0 ? void 0 : textBasedQueryColumns.map(({
      name
    }) => name)) !== null && _textBasedQueryColumn !== void 0 ? _textBasedQueryColumn : [];
  }));
};
const createTotalHitsObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.map)(state => ({
    status: state.totalHitsStatus,
    result: state.totalHitsResult
  })), (0, _rxjs.distinctUntilChanged)((prev, curr) => prev.status === curr.status && prev.result === curr.result));
};
const createCurrentSuggestionObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.map)(state => state.currentSuggestion), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual));
};