"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLayout = DiscoverLayout;
exports.SIDEBAR_CLOSED_KEY = void 0;
require("./discover_layout.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/data-plugin/public");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _public2 = require("@kbn/data-views-plugin/public");
var _constants = require("../../../../../common/constants");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _use_inspector = require("../../hooks/use_inspector");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _no_results = require("../no_results");
var _loading_spinner = require("../loading_spinner/loading_spinner");
var _sidebar = require("../sidebar");
var _common = require("../../../../../common");
var _popularize_field = require("../../../../utils/popularize_field");
var _discover_topnav = require("../top_nav/discover_topnav");
var _get_result_state = require("../../utils/get_result_state");
var _uninitialized = require("../uninitialized/uninitialized");
var _discover_data_state_container = require("../../services/discover_data_state_container");
var _use_data_grid_columns = require("../../../../hooks/use_data_grid_columns");
var _types = require("../../../types");
var _use_data_state = require("../../hooks/use_data_state");
var _get_raw_record_type = require("../../utils/get_raw_record_type");
var _saved_search_url_conflict_callout = require("../../../../components/saved_search_url_conflict_callout/saved_search_url_conflict_callout");
var _discover_histogram_layout = require("./discover_histogram_layout");
var _error_callout = require("../../../../components/common/error_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Local storage key for sidebar persistence state
 */
const SIDEBAR_CLOSED_KEY = 'discover:sidebarClosed';
exports.SIDEBAR_CLOSED_KEY = SIDEBAR_CLOSED_KEY;
const SidebarMemoized = /*#__PURE__*/_react.default.memo(_sidebar.DiscoverSidebarResponsive);
const TopNavMemoized = /*#__PURE__*/_react.default.memo(_discover_topnav.DiscoverTopNav);
function DiscoverLayout({
  inspectorAdapters,
  navigateTo,
  onChangeDataView,
  onUpdateQuery,
  resetSavedSearch,
  savedSearch,
  searchSource,
  stateContainer,
  persistDataView,
  updateAdHocDataViewId,
  updateDataViewList
}) {
  var _dragDropContext$drag;
  const {
    trackUiMetric,
    capabilities,
    dataViews,
    data,
    uiSettings,
    filterManager,
    storage,
    history,
    spaces,
    inspector
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    main$
  } = stateContainer.dataState.data$;
  const [query, savedQuery, columns, sort] = (0, _discover_app_state_container.useAppStateSelector)(state => [state.query, state.savedQuery, state.columns, state.sort]);
  const viewMode = (0, _discover_app_state_container.useAppStateSelector)(state => {
    var _state$viewMode;
    if (uiSettings.get(_common.SHOW_FIELD_STATISTICS) !== true) return _constants.VIEW_MODE.DOCUMENT_LEVEL;
    return (_state$viewMode = state.viewMode) !== null && _state$viewMode !== void 0 ? _state$viewMode : _constants.VIEW_MODE.DOCUMENT_LEVEL;
  });
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const dataState = (0, _use_data_state.useDataState)(main$);
  const fetchCounter = (0, _react.useRef)(0);
  (0, _react.useEffect)(() => {
    if (dataState.fetchStatus === _types.FetchStatus.LOADING) {
      fetchCounter.current++;
    }
  }, [dataState.fetchStatus]);

  // We treat rollup v1 data views as non time based in Discover, since we query them
  // in a non time based way using the regular _search API, since the internal
  // representation of those documents does not have the time field that _field_caps
  // reports us.
  const isTimeBased = (0, _react.useMemo)(() => {
    return dataView.type !== _public2.DataViewType.ROLLUP && dataView.isTimeBased();
  }, [dataView]);
  const initialSidebarClosed = Boolean(storage.get(SIDEBAR_CLOSED_KEY));
  const [isSidebarClosed, setIsSidebarClosed] = (0, _react.useState)(initialSidebarClosed);
  const useNewFieldsApi = (0, _react.useMemo)(() => !uiSettings.get(_common.SEARCH_FIELDS_FROM_SOURCE), [uiSettings]);
  const isPlainRecord = (0, _react.useMemo)(() => (0, _get_raw_record_type.getRawRecordType)(query) === _discover_data_state_container.RecordRawType.PLAIN, [query]);
  const resultState = (0, _react.useMemo)(() => (0, _get_result_state.getResultState)(dataState.fetchStatus, dataState.foundDocuments, isPlainRecord), [dataState.fetchStatus, dataState.foundDocuments, isPlainRecord]);
  const onOpenInspector = (0, _use_inspector.useInspector)({
    inspector,
    stateContainer,
    inspectorAdapters,
    savedSearch
  });
  const {
    columns: currentColumns,
    onAddColumn,
    onRemoveColumn
  } = (0, _use_data_grid_columns.useColumns)({
    capabilities,
    config: uiSettings,
    dataView,
    dataViews,
    setAppState: stateContainer.appState.update,
    useNewFieldsApi,
    columns,
    sort
  });
  const onAddFilter = (0, _react.useCallback)((field, values, operation) => {
    const fieldName = typeof field === 'string' ? field : field.name;
    (0, _popularize_field.popularizeField)(dataView, fieldName, dataViews, capabilities);
    const newFilters = (0, _public.generateFilters)(filterManager, field, values, operation, dataView);
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'filter_added');
    }
    return filterManager.addFilters(newFilters);
  }, [filterManager, dataView, dataViews, trackUiMetric, capabilities]);
  const onFieldEdited = (0, _react.useCallback)(async ({
    removedFieldName
  } = {}) => {
    if (removedFieldName && currentColumns.includes(removedFieldName)) {
      onRemoveColumn(removedFieldName);
    }
    if (!dataView.isPersisted()) {
      await updateAdHocDataViewId(dataView);
    }
    stateContainer.dataState.refetch$.next('reset');
  }, [dataView, stateContainer, updateAdHocDataViewId, currentColumns, onRemoveColumn]);
  const onDisableFilters = (0, _react.useCallback)(() => {
    const disabledFilters = filterManager.getFilters().map(filter => ({
      ...filter,
      meta: {
        ...filter.meta,
        disabled: true
      }
    }));
    filterManager.setFilters(disabledFilters);
  }, [filterManager]);
  const toggleSidebarCollapse = (0, _react.useCallback)(() => {
    storage.set(SIDEBAR_CLOSED_KEY, !isSidebarClosed);
    setIsSidebarClosed(!isSidebarClosed);
  }, [isSidebarClosed, storage]);
  const contentCentered = resultState === 'uninitialized' || resultState === 'none';
  const onDataViewCreated = (0, _react.useCallback)(async nextDataView => {
    if (!nextDataView.isPersisted()) {
      stateContainer.actions.appendAdHocDataViews(nextDataView);
    } else {
      await stateContainer.actions.loadDataViewList();
    }
    if (nextDataView.id) {
      onChangeDataView(nextDataView.id);
    }
  }, [onChangeDataView, stateContainer]);
  const savedSearchTitle = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _savedSearchTitle$cur;
    (_savedSearchTitle$cur = savedSearchTitle.current) === null || _savedSearchTitle$cur === void 0 ? void 0 : _savedSearchTitle$cur.focus();
  }, []);
  const textBasedLanguageModeErrors = (0, _react.useMemo)(() => {
    if (isPlainRecord) {
      return dataState.error;
    }
  }, [dataState.error, isPlainRecord]);
  const resizeRef = (0, _react.useRef)(null);
  const dragDropContext = (0, _react.useContext)(_domDragDrop.DragContext);
  const draggingFieldName = (_dragDropContext$drag = dragDropContext.dragging) === null || _dragDropContext$drag === void 0 ? void 0 : _dragDropContext$drag.id;
  const onDropFieldToTable = (0, _react.useMemo)(() => {
    if (!draggingFieldName || currentColumns.includes(draggingFieldName)) {
      return undefined;
    }
    return () => onAddColumn(draggingFieldName);
  }, [onAddColumn, draggingFieldName, currentColumns]);
  const mainDisplay = (0, _react.useMemo)(() => {
    if (resultState === 'none') {
      const globalQueryState = data.query.getState();
      return /*#__PURE__*/_react.default.createElement(_no_results.DiscoverNoResults, {
        isTimeBased: isTimeBased,
        query: globalQueryState.query,
        filters: globalQueryState.filters,
        dataView: dataView,
        onDisableFilters: onDisableFilters
      });
    }
    if (resultState === 'uninitialized') {
      return /*#__PURE__*/_react.default.createElement(_uninitialized.DiscoverUninitialized, {
        onRefresh: () => stateContainer.dataState.refetch$.next(undefined)
      });
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_discover_histogram_layout.DiscoverHistogramLayout, {
      isPlainRecord: isPlainRecord,
      dataView: dataView,
      navigateTo: navigateTo,
      resetSavedSearch: resetSavedSearch,
      savedSearch: savedSearch,
      stateContainer: stateContainer,
      columns: currentColumns,
      viewMode: viewMode,
      onAddFilter: onAddFilter,
      onFieldEdited: onFieldEdited,
      resizeRef: resizeRef,
      inspectorAdapters: inspectorAdapters,
      onDropFieldToTable: onDropFieldToTable
    }), resultState === 'loading' && /*#__PURE__*/_react.default.createElement(_loading_spinner.LoadingSpinner, null));
  }, [currentColumns, data, dataView, inspectorAdapters, isPlainRecord, isTimeBased, navigateTo, onAddFilter, onDisableFilters, onFieldEdited, resetSavedSearch, resultState, savedSearch, stateContainer, viewMode, onDropFieldToTable]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    className: "dscPage",
    "data-fetch-counter": fetchCounter.current
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "savedSearchTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverSavedSearchTitle",
    tabIndex: -1,
    ref: savedSearchTitle
  }, savedSearch.title ? _i18n.i18n.translate('discover.pageTitleWithSavedSearch', {
    defaultMessage: 'Discover - {savedSearchTitle}',
    values: {
      savedSearchTitle: savedSearch.title
    }
  }) : _i18n.i18n.translate('discover.pageTitleWithoutSavedSearch', {
    defaultMessage: 'Discover - Search not yet saved'
  })), /*#__PURE__*/_react.default.createElement(TopNavMemoized, {
    onOpenInspector: onOpenInspector,
    query: query,
    navigateTo: navigateTo,
    savedQuery: savedQuery,
    savedSearch: savedSearch,
    searchSource: searchSource,
    stateContainer: stateContainer,
    updateQuery: onUpdateQuery,
    resetSavedSearch: resetSavedSearch,
    onChangeDataView: onChangeDataView,
    onDataViewCreated: onDataViewCreated,
    isPlainRecord: isPlainRecord,
    textBasedLanguageModeErrors: textBasedLanguageModeErrors,
    onFieldEdited: onFieldEdited,
    persistDataView: persistDataView,
    updateAdHocDataViewId: updateAdHocDataViewId,
    updateDataViewList: updateDataViewList
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    className: "dscPageBody",
    "aria-describedby": "savedSearchTitle"
  }, /*#__PURE__*/_react.default.createElement(_saved_search_url_conflict_callout.SavedSearchURLConflictCallout, {
    savedSearch: savedSearch,
    spaces: spaces,
    history: history
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "dscPageBody__contents",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(SidebarMemoized, {
    documents$: stateContainer.dataState.data$.documents$,
    onAddField: onAddColumn,
    columns: currentColumns,
    onAddFilter: !isPlainRecord ? onAddFilter : undefined,
    onRemoveField: onRemoveColumn,
    onChangeDataView: onChangeDataView,
    selectedDataView: dataView,
    isClosed: isSidebarClosed,
    trackUiMetric: trackUiMetric,
    useNewFieldsApi: useNewFieldsApi,
    onFieldEdited: onFieldEdited,
    viewMode: viewMode,
    onDataViewCreated: onDataViewCreated,
    availableFields$: stateContainer.dataState.data$.availableFields$
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isSidebarClosed ? 'menuRight' : 'menuLeft',
    iconSize: "m",
    size: "xs",
    onClick: toggleSidebarCollapse,
    "data-test-subj": "collapseSideBarButton",
    "aria-controls": "discover-sidebar",
    "aria-expanded": isSidebarClosed ? 'false' : 'true',
    "aria-label": _i18n.i18n.translate('discover.toggleSidebarAriaLabel', {
      defaultMessage: 'Toggle sidebar'
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "dscPageContent__wrapper"
  }, resultState === 'none' && dataState.error ? /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    title: _i18n.i18n.translate('discover.noResults.searchExamples.noResultsErrorTitle', {
      defaultMessage: 'Unable to retrieve search results'
    }),
    error: dataState.error,
    "data-test-subj": "discoverNoResultsError"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    panelRef: resizeRef,
    verticalPosition: contentCentered ? 'center' : undefined,
    horizontalPosition: contentCentered ? 'center' : undefined,
    paddingSize: "none",
    hasShadow: false,
    className: (0, _classnames.default)('dscPageContent', {
      'dscPageContent--centered': contentCentered,
      'dscPageContent--emptyPrompt': resultState === 'none'
    })
  }, mainDisplay)))));
}