"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onResize = exports.DiscoverDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
var _discover_app_state_container = require("../../services/discover_app_state_container");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _discover_grid = require("../../../../components/discover_grid/discover_grid");
var _types = require("../../../types");
var _common = require("../../../../../common");
var _use_data_grid_columns = require("../../../../hooks/use_data_grid_columns");
var _discover_data_state_container = require("../../services/discover_data_state_container");
var _use_data_state = require("../../hooks/use_data_state");
var _doc_table_infinite = require("../../../../components/doc_table/doc_table_infinite");
var _document_explorer_callout = require("../document_explorer_callout");
var _document_explorer_update_callout = require("../document_explorer_callout/document_explorer_update_callout");
var _discover_tour = require("../../../../components/discover_tour");
var _get_raw_record_type = require("../../utils/get_raw_record_type");
var _discover_grid_flyout = require("../../../../components/discover_grid/discover_grid_flyout");
var _doc_viewer = require("../../../../services/doc_views/components/doc_viewer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const containerStyles = (0, _react2.css)`
  position: relative;
`;
const progressStyle = (0, _react2.css)`
  z-index: 2;
`;
const DocTableInfiniteMemoized = /*#__PURE__*/_react.default.memo(_doc_table_infinite.DocTableInfinite);
const DataGridMemoized = /*#__PURE__*/_react.default.memo(_discover_grid.DiscoverGrid);

// export needs for testing
const onResize = (colSettings, stateContainer) => {
  const state = stateContainer.appState.getState();
  const grid = {
    ...(state.grid || {})
  };
  const newColumns = {
    ...(grid.columns || {})
  };
  newColumns[colSettings.columnId] = {
    width: Math.round(colSettings.width)
  };
  const newGrid = {
    ...grid,
    columns: newColumns
  };
  stateContainer.appState.update({
    grid: newGrid
  });
};
exports.onResize = onResize;
function DiscoverDocumentsComponent({
  dataView,
  onAddFilter,
  savedSearch,
  stateContainer,
  onFieldEdited
}) {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const documents$ = stateContainer.dataState.data$.documents$;
  const {
    dataViews,
    capabilities,
    uiSettings
  } = services;
  const [query, sort, rowHeight, rowsPerPage, grid, columns, index] = (0, _discover_app_state_container.useAppStateSelector)(state => {
    return [state.query, state.sort, state.rowHeight, state.rowsPerPage, state.grid, state.columns, state.index];
  });
  const setExpandedDoc = (0, _react.useCallback)(doc => {
    stateContainer.internalState.transitions.setExpandedDoc(doc);
  }, [stateContainer]);
  const expandedDoc = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.expandedDoc);
  const useNewFieldsApi = (0, _react.useMemo)(() => !uiSettings.get(_common.SEARCH_FIELDS_FROM_SOURCE), [uiSettings]);
  const hideAnnouncements = (0, _react.useMemo)(() => uiSettings.get(_common.HIDE_ANNOUNCEMENTS), [uiSettings]);
  const isLegacy = (0, _react.useMemo)(() => uiSettings.get(_common.DOC_TABLE_LEGACY), [uiSettings]);
  const sampleSize = (0, _react.useMemo)(() => uiSettings.get(_common.SAMPLE_SIZE_SETTING), [uiSettings]);
  const documentState = (0, _use_data_state.useDataState)(documents$);
  const isDataLoading = documentState.fetchStatus === _types.FetchStatus.LOADING;
  // This is needed to prevent EuiDataGrid pushing onSort because the data view has been switched.
  // 1. When switching the data view, the sorting in the URL is reset to the default sorting of the selected data view.
  // 2. The new sort param is already available in this component and propagated to the EuiDataGrid.
  // 3. currentColumns are still referring to the old state
  // 4. since the new sort by field isn't available in currentColumns EuiDataGrid is emitting a 'onSort', which is unsorting the grid
  // 5. this is propagated to Discover's URL and causes an unwanted change of state to an unsorted state
  // This solution switches to the loading state in this component when the URL index doesn't match the dataView.id
  const isDataViewLoading = index && dataView.id && index !== dataView.id;
  const isEmptyDataResult = !documentState.result || documentState.result.length === 0;
  const isPlainRecord = (0, _react.useMemo)(() => (0, _get_raw_record_type.getRawRecordType)(query) === _discover_data_state_container.RecordRawType.PLAIN, [query]);
  const rows = (0, _react.useMemo)(() => documentState.result || [], [documentState.result]);
  const {
    columns: currentColumns,
    onAddColumn,
    onRemoveColumn,
    onMoveColumn,
    onSetColumns
  } = (0, _use_data_grid_columns.useColumns)({
    capabilities,
    config: uiSettings,
    dataView,
    dataViews,
    setAppState: stateContainer.appState.update,
    useNewFieldsApi,
    columns,
    sort
  });
  const onResizeDataGrid = (0, _react.useCallback)(colSettings => onResize(colSettings, stateContainer), [stateContainer]);
  const onUpdateRowsPerPage = (0, _react.useCallback)(nextRowsPerPage => {
    stateContainer.appState.update({
      rowsPerPage: nextRowsPerPage
    });
  }, [stateContainer]);
  const onSort = (0, _react.useCallback)(nextSort => {
    stateContainer.appState.update({
      sort: nextSort
    });
  }, [stateContainer]);
  const onUpdateRowHeight = (0, _react.useCallback)(newRowHeight => {
    stateContainer.appState.update({
      rowHeight: newRowHeight
    });
  }, [stateContainer]);
  const showTimeCol = (0, _react.useMemo)(() => !isPlainRecord && !uiSettings.get(_common.DOC_HIDE_TIME_COLUMN_SETTING, false) && !!dataView.timeFieldName, [isPlainRecord, uiSettings, dataView.timeFieldName]);
  if (isDataViewLoading || isEmptyDataResult && isDataLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "dscDocuments__loading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.loadingDocuments",
      defaultMessage: "Loading documents"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "dscTable",
    "aria-labelledby": "documentsAriaLabel",
    css: containerStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: "documentsAriaLabel"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.documentsAriaLabel",
    defaultMessage: "Documents"
  }))), isLegacy && rows && rows.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideAnnouncements && /*#__PURE__*/_react.default.createElement(_document_explorer_callout.DocumentExplorerCallout, null), /*#__PURE__*/_react.default.createElement(DocTableInfiniteMemoized, {
    columns: currentColumns,
    dataView: dataView,
    rows: rows,
    sort: sort || [],
    isLoading: isDataLoading,
    searchDescription: savedSearch.description,
    sharedItemTitle: savedSearch.title,
    onAddColumn: onAddColumn,
    onFilter: onAddFilter,
    onMoveColumn: onMoveColumn,
    onRemoveColumn: onRemoveColumn,
    onSort: !isPlainRecord ? onSort : undefined,
    useNewFieldsApi: useNewFieldsApi,
    dataTestSubj: "discoverDocTable",
    DocViewer: _doc_viewer.DocViewer
  })), !isLegacy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !hideAnnouncements && !isPlainRecord && /*#__PURE__*/_react.default.createElement(_discover_tour.DiscoverTourProvider, {
    isPlainRecord: isPlainRecord
  }, /*#__PURE__*/_react.default.createElement(_document_explorer_update_callout.DocumentExplorerUpdateCallout, null)), /*#__PURE__*/_react.default.createElement("div", {
    className: "dscDiscoverGrid"
  }, /*#__PURE__*/_react.default.createElement(DataGridMemoized, {
    ariaLabelledBy: "documentsAriaLabel",
    columns: currentColumns,
    expandedDoc: expandedDoc,
    dataView: dataView,
    isLoading: isDataLoading,
    rows: rows,
    sort: sort || [],
    sampleSize: sampleSize,
    searchDescription: savedSearch.description,
    searchTitle: savedSearch.title,
    setExpandedDoc: !isPlainRecord ? setExpandedDoc : undefined,
    showTimeCol: showTimeCol,
    settings: grid,
    onAddColumn: onAddColumn,
    onFilter: onAddFilter,
    onRemoveColumn: onRemoveColumn,
    onSetColumns: onSetColumns,
    onSort: !isPlainRecord ? onSort : undefined,
    onResize: onResizeDataGrid,
    useNewFieldsApi: useNewFieldsApi,
    rowHeightState: rowHeight,
    onUpdateRowHeight: onUpdateRowHeight,
    isSortEnabled: !isPlainRecord,
    isPlainRecord: isPlainRecord,
    rowsPerPageState: rowsPerPage,
    onUpdateRowsPerPage: onUpdateRowsPerPage,
    onFieldEdited: onFieldEdited,
    savedSearchId: savedSearch.id,
    DocumentView: _discover_grid_flyout.DiscoverGridFlyout,
    services: services
  }))), isDataLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    css: progressStyle
  }));
}
const DiscoverDocuments = /*#__PURE__*/(0, _react.memo)(DiscoverDocumentsComponent);
exports.DiscoverDocuments = DiscoverDocuments;