"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _discover_router = require("./discover_router");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const renderApp = (element, services, isDev) => {
  const {
    history: getHistory,
    capabilities,
    chrome,
    data,
    core
  } = services;
  const history = getHistory();
  if (!capabilities.discover.save) {
    chrome.setBadge({
      text: _i18n.i18n.translate('discover.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('discover.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save searches'
      }),
      iconType: 'glasses'
    });
  }
  const unmount = (0, _public.toMountPoint)((0, _public.wrapWithTheme)((0, _discover_router.discoverRouter)(services, history, isDev), core.theme.theme$))(element);
  return () => {
    unmount();
    data.search.session.clear();
  };
};
exports.renderApp = renderApp;