"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleDocRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _loading_indicator = require("../../components/common/loading_indicator");
var _doc = require("./components/doc");
var _use_discover_services = require("../../hooks/use_discover_services");
var _kibana_services = require("../../kibana_services");
var _error_alert = require("../../components/common/error_alert");
var _use_data_view = require("../../hooks/use_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SingleDocRoute = () => {
  const {
    timefilter,
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    dataViewId,
    index
  } = (0, _reactRouterDom.useParams)();
  const query = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const id = query.get('id');
  const locationState = (0, _react.useMemo)(() => (0, _kibana_services.getScopedHistory)().location.state, []);
  (0, _public.useExecutionContext)(core.executionContext, {
    type: 'application',
    page: 'single-doc',
    id: dataViewId
  });
  (0, _react.useEffect)(() => {
    timefilter.disableAutoRefreshSelector();
    timefilter.disableTimeRangeSelector();
  }, [timefilter]);
  const {
    dataView,
    error
  } = (0, _use_data_view.useDataView)({
    index: (locationState === null || locationState === void 0 ? void 0 : locationState.dataViewSpec) || decodeURIComponent(dataViewId)
  });
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.singleDocRoute.errorTitle",
        defaultMessage: "An error occurred"
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.singleDocRoute.errorMessage",
        defaultMessage: "No matching data view for id {dataViewId}",
        values: {
          dataViewId
        }
      })
    });
  }
  if (!dataView) {
    return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, null);
  }
  if (!id) {
    return /*#__PURE__*/_react.default.createElement(_error_alert.DiscoverError, {
      error: new Error(_i18n.i18n.translate('discover.discoverError.missingIdParamError', {
        defaultMessage: 'No document ID provided. Return to Discover to select another document.'
      }))
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "app-container"
  }, /*#__PURE__*/_react.default.createElement(_doc.Doc, {
    id: id,
    index: index,
    dataView: dataView,
    referrer: locationState === null || locationState === void 0 ? void 0 : locationState.referrer
  }));
};
exports.SingleDocRoute = SingleDocRoute;