"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialContextQueryState = exports.LoadingStatus = exports.FailureReason = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
let LoadingStatus;
exports.LoadingStatus = LoadingStatus;
(function (LoadingStatus) {
  LoadingStatus["FAILED"] = "failed";
  LoadingStatus["LOADED"] = "loaded";
  LoadingStatus["LOADING"] = "loading";
  LoadingStatus["UNINITIALIZED"] = "uninitialized";
})(LoadingStatus || (exports.LoadingStatus = LoadingStatus = {}));
let FailureReason;
exports.FailureReason = FailureReason;
(function (FailureReason) {
  FailureReason["UNKNOWN"] = "unknown";
  FailureReason["INVALID_TIEBREAKER"] = "invalid_tiebreaker";
})(FailureReason || (exports.FailureReason = FailureReason = {}));
const getInitialContextQueryState = () => ({
  anchor: {},
  predecessors: [],
  successors: [],
  anchorStatus: {
    value: LoadingStatus.UNINITIALIZED
  },
  predecessorsStatus: {
    value: LoadingStatus.UNINITIALIZED
  },
  successorsStatus: {
    value: LoadingStatus.UNINITIALIZED
  }
});
exports.getInitialContextQueryState = getInitialContextQueryState;