"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAnchor = fetchAnchor;
exports.updateSearchSource = updateSearchSource;
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _build_data_record = require("../../../utils/build_data_record");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function fetchAnchor(anchorId, dataView, searchSource, sort, useNewFieldsApi = false) {
  var _rawResponse$hits, _rawResponse$hits$hit;
  updateSearchSource(searchSource, anchorId, sort, useNewFieldsApi, dataView);
  const {
    rawResponse
  } = await (0, _rxjs.lastValueFrom)(searchSource.fetch$());
  const doc = (_rawResponse$hits = rawResponse.hits) === null || _rawResponse$hits === void 0 ? void 0 : (_rawResponse$hits$hit = _rawResponse$hits.hits) === null || _rawResponse$hits$hit === void 0 ? void 0 : _rawResponse$hits$hit[0];
  if (!doc) {
    throw new Error(_i18n.i18n.translate('discover.context.failedToLoadAnchorDocumentErrorDescription', {
      defaultMessage: 'Failed to load anchor document.'
    }));
  }
  return (0, _build_data_record.buildDataTableRecord)(doc, dataView, true);
}
function updateSearchSource(searchSource, anchorId, sort, useNewFieldsApi, dataView) {
  searchSource.setParent(undefined).setField('index', dataView).setField('version', true).setField('size', 1).setField('query', {
    query: {
      constant_score: {
        filter: {
          ids: {
            values: [anchorId]
          }
        }
      }
    },
    language: 'lucene'
  }).setField('sort', sort).setField('trackTotalHits', false);
  if (useNewFieldsApi) {
    searchSource.removeField('fieldsFromSource');
    searchSource.setField('fields', [{
      field: '*',
      include_unmapped: 'true'
    }]);
  }
  return searchSource;
}