"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createContextSearchSourceStub = createContextSearchSourceStub;
exports.createSearchSourceStub = createSearchSourceStub;
var _sinon = _interopRequireDefault(require("sinon"));
var _moment = _interopRequireDefault(require("moment"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A stubbed search source with a `fetch` method that returns all of `_stubHits`.
 */
function createSearchSourceStub(hits, timeField) {
  const requestResult = {
    id: 'Fjk5bndxTHJWU2FldVRVQ0tYR0VqOFEcRWtWNDhOdG5SUzJYcFhONVVZVTBJQToxMDMwOQ==',
    rawResponse: {
      took: 2,
      timed_out: false,
      _shards: {
        total: 1,
        successful: 1,
        skipped: 0,
        failed: 0
      },
      hits: {
        hits,
        total: hits.length
      }
    },
    isPartial: false,
    isRunning: false,
    total: 1,
    loaded: 1,
    isRestored: false
  };
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const searchSourceStub = {
    _stubHits: hits,
    _stubTimeField: timeField,
    _createStubHit: (timestamp, tiebreaker = 0) => ({
      [searchSourceStub._stubTimeField]: timestamp,
      sort: [timestamp, tiebreaker]
    }),
    setParent: _sinon.default.spy(() => searchSourceStub),
    setField: _sinon.default.spy(() => searchSourceStub),
    removeField: _sinon.default.spy(() => searchSourceStub),
    getField: _sinon.default.spy(key => {
      const previousSetCall = searchSourceStub.setField.withArgs(key).lastCall;
      return previousSetCall ? previousSetCall.args[1] : null;
    }),
    fetch$: _sinon.default.spy(() => (0, _rxjs.of)(requestResult))
  };
  return searchSourceStub;
}

/**
 * A stubbed search source with a `fetch` method that returns a filtered set of `_stubHits`.
 */
function createContextSearchSourceStub(timeFieldName) {
  const searchSourceStub = createSearchSourceStub([], timeFieldName);
  searchSourceStub.fetch$ = _sinon.default.spy(() => {
    const timeField = searchSourceStub._stubTimeField;
    const lastQuery = searchSourceStub.setField.withArgs('query').lastCall.args[1];
    const timeRange = lastQuery.query.bool.must.constant_score.filter.range[timeField];
    const lastSort = searchSourceStub.setField.withArgs('sort').lastCall.args[1];
    const sortDirection = lastSort[0][timeField].order;
    const sortFunction = sortDirection === 'asc' ? (first, second) => first[timeField] - second[timeField] : (first, second) => second[timeField] - first[timeField];
    const filteredHits = searchSourceStub._stubHits.filter(hit => (0, _moment.default)(hit[timeField]).isSameOrAfter(timeRange.gte) && (0, _moment.default)(hit[timeField]).isSameOrBefore(timeRange.lte)).sort(sortFunction);
    return (0, _rxjs.of)({
      rawResponse: {
        hits: {
          hits: filteredHits,
          total: filteredHits.length
        }
      }
    });
  });
  return searchSourceStub;
}