"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContextAppFetch = useContextAppFetch;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _common = require("../../../../common");
var _anchor = require("../services/anchor");
var _context = require("../services/context");
var _context_query_state = require("../services/context_query_state");
var _sorting = require("../utils/sorting");
var _use_discover_services = require("../../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createError = (statusKey, reason, error) => ({
  [statusKey]: {
    value: _context_query_state.LoadingStatus.FAILED,
    error,
    reason
  }
});
function useContextAppFetch({
  anchorId,
  dataView,
  appState,
  useNewFieldsApi
}) {
  const {
    uiSettings: config,
    data,
    toastNotifications,
    filterManager,
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    theme$
  } = core.theme;
  const searchSource = (0, _react.useMemo)(() => {
    return data.search.searchSource.createEmpty();
  }, [data.search.searchSource]);
  const tieBreakerField = (0, _react.useMemo)(() => (0, _sorting.getFirstSortableField)(dataView, config.get(_common.CONTEXT_TIE_BREAKER_FIELDS_SETTING)), [config, dataView]);
  const [fetchedState, setFetchedState] = (0, _react.useState)((0, _context_query_state.getInitialContextQueryState)());
  const setState = (0, _react.useCallback)(values => {
    setFetchedState(prevState => ({
      ...prevState,
      ...values
    }));
  }, []);
  const fetchAnchorRow = (0, _react.useCallback)(async () => {
    const errorTitle = _i18n.i18n.translate('discover.context.unableToLoadAnchorDocumentDescription', {
      defaultMessage: 'Unable to load the anchor document'
    });
    if (!tieBreakerField) {
      setState(createError('anchorStatus', _context_query_state.FailureReason.INVALID_TIEBREAKER));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _public.toMountPoint)((0, _public.wrapWithTheme)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, _i18n.i18n.translate('discover.context.invalidTieBreakerFiledSetting', {
          defaultMessage: 'Invalid tie breaker field setting'
        })), theme$))
      });
      return;
    }
    try {
      setState({
        anchorStatus: {
          value: _context_query_state.LoadingStatus.LOADING
        }
      });
      const sort = [{
        [dataView.timeFieldName]: _public2.SortDirection.desc
      }, {
        [tieBreakerField]: _public2.SortDirection.desc
      }];
      const anchor = await (0, _anchor.fetchAnchor)(anchorId, dataView, searchSource, sort, useNewFieldsApi);
      setState({
        anchor,
        anchorStatus: {
          value: _context_query_state.LoadingStatus.LOADED
        }
      });
      return anchor;
    } catch (error) {
      setState(createError('anchorStatus', _context_query_state.FailureReason.UNKNOWN, error));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _public.toMountPoint)((0, _public.wrapWithTheme)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, error.message), theme$))
      });
    }
  }, [tieBreakerField, setState, toastNotifications, dataView, anchorId, searchSource, useNewFieldsApi, theme$]);
  const fetchSurroundingRows = (0, _react.useCallback)(async (type, fetchedAnchor) => {
    const filters = filterManager.getFilters();
    const count = type === _context.SurrDocType.PREDECESSORS ? appState.predecessorCount : appState.successorCount;
    const anchor = fetchedAnchor || fetchedState.anchor;
    const statusKey = `${type}Status`;
    const errorTitle = _i18n.i18n.translate('discover.context.unableToLoadDocumentDescription', {
      defaultMessage: 'Unable to load documents'
    });
    try {
      setState({
        [statusKey]: {
          value: _context_query_state.LoadingStatus.LOADING
        }
      });
      const rows = anchor.id ? await (0, _context.fetchSurroundingDocs)(type, dataView, anchor, tieBreakerField, _public2.SortDirection.desc, count, filters, data, useNewFieldsApi) : [];
      setState({
        [type]: rows,
        [statusKey]: {
          value: _context_query_state.LoadingStatus.LOADED
        }
      });
    } catch (error) {
      setState(createError(statusKey, _context_query_state.FailureReason.UNKNOWN, error));
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _public.toMountPoint)((0, _public.wrapWithTheme)( /*#__PURE__*/_react.default.createElement(_public.MarkdownSimple, null, error.message), theme$))
      });
    }
  }, [filterManager, appState, fetchedState.anchor, tieBreakerField, setState, dataView, toastNotifications, useNewFieldsApi, theme$, data]);
  const fetchContextRows = (0, _react.useCallback)(anchor => Promise.allSettled([fetchSurroundingRows(_context.SurrDocType.PREDECESSORS, anchor), fetchSurroundingRows(_context.SurrDocType.SUCCESSORS, anchor)]), [fetchSurroundingRows]);
  const fetchAllRows = (0, _react.useCallback)(() => {
    fetchAnchorRow().then(anchor => anchor && fetchContextRows(anchor));
  }, [fetchAnchorRow, fetchContextRows]);
  const resetFetchedState = (0, _react.useCallback)(() => {
    setFetchedState((0, _context_query_state.getInitialContextQueryState)());
  }, []);
  return {
    fetchedState,
    fetchAllRows,
    fetchContextRows,
    fetchSurroundingRows,
    resetFetchedState
  };
}