"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextAppRoute = ContextAppRoute;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _context_app = require("./context_app");
var _loading_indicator = require("../../components/common/loading_indicator");
var _kibana_services = require("../../kibana_services");
var _use_data_view = require("../../hooks/use_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ContextAppRoute() {
  const locationState = (0, _react.useMemo)(() => (0, _kibana_services.getScopedHistory)().location.state, []);

  /**
   * Updates history state when gets undefined.
   * Should be removed once url state will be deleted from context page.
   */
  (0, _react.useEffect)(() => {
    const scopedHistory = (0, _kibana_services.getScopedHistory)();
    const unlisten = scopedHistory.listen(location => {
      const currentState = location.state;
      if (!(currentState !== null && currentState !== void 0 && currentState.referrer) && locationState) {
        const newLocation = {
          ...location,
          state: {
            ...currentState,
            ...locationState
          }
        };
        scopedHistory.replace(newLocation);
      }
    });
    return () => unlisten();
  }, [locationState]);
  const {
    dataViewId: encodedDataViewId,
    id
  } = (0, _reactRouterDom.useParams)();
  const dataViewId = decodeURIComponent(encodedDataViewId);
  const anchorId = decodeURIComponent(id);
  const {
    dataView,
    error
  } = (0, _use_data_view.useDataView)({
    index: (locationState === null || locationState === void 0 ? void 0 : locationState.dataViewSpec) || dataViewId
  });
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.contextViewRoute.errorTitle",
        defaultMessage: "An error occurred"
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.contextViewRoute.errorMessage",
        defaultMessage: "No matching data view for id {dataViewId}",
        values: {
          dataViewId
        }
      })
    });
  }
  if (!dataView) {
    return /*#__PURE__*/_react.default.createElement(_loading_indicator.LoadingIndicator, null);
  }
  return /*#__PURE__*/_react.default.createElement(_context_app.ContextApp, {
    anchorId: anchorId,
    dataView: dataView,
    referrer: locationState === null || locationState === void 0 ? void 0 : locationState.referrer
  });
}