"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortForSearchSource = getSortForSearchSource;
var _get_sort = require("./get_sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Prepares sort for search source, that's sending the request to ES
 * - Adds default sort if necessary
 * - Handles the special case when there's sorting by date_nanos typed fields
 *   the addon of the numeric_type guarantees the right sort order
 *   when there are indices with date and indices with date_nanos field
 */
function getSortForSearchSource(sort, dataView, defaultDirection = 'desc') {
  if (!sort || !dataView || Array.isArray(sort) && sort.length === 0) {
    if (dataView !== null && dataView !== void 0 && dataView.timeFieldName) {
      // sorting by index order
      return [{
        _doc: defaultDirection
      }];
    } else {
      return [{
        _score: defaultDirection
      }];
    }
  }
  const {
    timeFieldName
  } = dataView;
  return (0, _get_sort.getSort)(sort, dataView).map(sortPair => {
    if (dataView.isTimeNanosBased() && timeFieldName && sortPair[timeFieldName]) {
      return {
        [timeFieldName]: {
          order: sortPair[timeFieldName],
          numeric_type: 'date_nanos'
        }
      };
    }
    return sortPair;
  });
}