"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverEnhancedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DiscoverEnhancedPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.context = context;
    this.config = context.config.get();
  }
  setup(core, {
    uiActions,
    share
  }) {
    const start = (0, _public2.createStartServicesGetter)(core.getStartServices);
    const isSharePluginInstalled = !!share;
    if (isSharePluginInstalled) {
      const params = {
        start
      };
      if (this.config.actions.exploreDataInContextMenu.enabled) {
        const exploreDataAction = new _actions.ExploreDataContextMenuAction(params);
        uiActions.addTriggerAction(_public3.CONTEXT_MENU_TRIGGER, exploreDataAction);
      }
      if (this.config.actions.exploreDataInChart.enabled) {
        const exploreDataChartAction = new _actions.ExploreDataChartAction(params);
        uiActions.addTriggerAction(_public.APPLY_FILTER_TRIGGER, exploreDataChartAction);
      }
    }
  }
  start(core, plugins) {}
  stop() {}
}
exports.DiscoverEnhancedPlugin = DiscoverEnhancedPlugin;