"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExploreDataChartAction = exports.ACTION_EXPLORE_DATA_CHART = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var shared = _interopRequireWildcard(require("./shared"));
var _abstract_explore_data_action = require("./abstract_explore_data_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ACTION_EXPLORE_DATA_CHART = 'ACTION_EXPLORE_DATA_CHART';

/**
 * This is "Explore underlying data" action which appears in popup context
 * menu when user clicks a value in visualization or brushes a time range.
 */
exports.ACTION_EXPLORE_DATA_CHART = ACTION_EXPLORE_DATA_CHART;
class ExploreDataChartAction extends _abstract_explore_data_action.AbstractExploreDataAction {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", ACTION_EXPLORE_DATA_CHART);
    (0, _defineProperty2.default)(this, "type", ACTION_EXPLORE_DATA_CHART);
    (0, _defineProperty2.default)(this, "order", 200);
    (0, _defineProperty2.default)(this, "getLocation", async context => {
      const {
        plugins
      } = this.params.start();
      const {
        locator
      } = plugins.discover;
      if (!locator) {
        throw new Error('Discover URL locator not available.');
      }
      const {
        embeddable
      } = context;
      const {
        extractTimeRange
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      const {
        restOfFilters: filters,
        timeRange
      } = extractTimeRange(context.filters, context.timeFieldName);
      const params = {
        filters,
        timeRange
      };
      if (embeddable) {
        params.indexPatternId = shared.getIndexPatterns(embeddable)[0] || undefined;
        const input = embeddable.getInput();
        if (input.timeRange && !params.timeRange) params.timeRange = input.timeRange;
        if (input.query) params.query = input.query;
        if (input.filters) params.filters = [...input.filters, ...(params.filters || [])];
      }
      const location = await locator.getLocation(params);
      return location;
    });
  }
  async isCompatible(context) {
    var _context$embeddable;
    if (((_context$embeddable = context.embeddable) === null || _context$embeddable === void 0 ? void 0 : _context$embeddable.type) === 'map') return false; // TODO: https://github.com/elastic/kibana/issues/73043
    return super.isCompatible(context);
  }
}
exports.ExploreDataChartAction = ExploreDataChartAction;