"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _public = require("@kbn/core/public");
var _dev_tool = require("./dev_tool");
var _services = require("./services");
require("./index.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class DevToolsPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "devTools", new Map());
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "breadcrumbService", new _services.BreadcrumbService());
    (0, _defineProperty2.default)(this, "docTitleService", new _services.DocTitleService());
  }
  getSortedDevTools() {
    return (0, _lodash.sortBy)([...this.devTools.values()], 'order');
  }
  setup(coreSetup, {
    urlForwarding
  }) {
    const {
      application: applicationSetup,
      getStartServices
    } = coreSetup;
    applicationSetup.register({
      id: 'dev_tools',
      title: _i18n.i18n.translate('devTools.devToolsTitle', {
        defaultMessage: 'Dev Tools'
      }),
      updater$: this.appStateUpdater,
      euiIconType: 'logoElastic',
      order: 9010,
      category: _public.DEFAULT_APP_CATEGORIES.management,
      mount: async params => {
        const {
          element,
          history,
          theme$
        } = params;
        element.classList.add('devAppWrapper');
        const [core] = await getStartServices();
        const {
          application,
          chrome,
          executionContext
        } = core;
        this.docTitleService.setup(chrome.docTitle.change);
        this.breadcrumbService.setup(chrome.setBreadcrumbs);
        const appServices = {
          breadcrumbService: this.breadcrumbService,
          docTitleService: this.docTitleService,
          executionContext
        };
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        return renderApp(element, application, chrome, history, theme$, this.getSortedDevTools(), appServices);
      }
    });
    urlForwarding.forwardApp('dev_tools', 'dev_tools');
    return {
      register: devToolArgs => {
        if (this.devTools.has(devToolArgs.id)) {
          throw new Error(`Dev tool with id [${devToolArgs.id}] has already been registered. Use a unique id.`);
        }
        const devTool = (0, _dev_tool.createDevToolApp)(devToolArgs);
        this.devTools.set(devTool.id, devTool);
        return devTool;
      }
    };
  }
  start() {
    if (this.getSortedDevTools().length === 0) {
      this.appStateUpdater.next(() => ({
        navLinkStatus: _public.AppNavLinkStatus.hidden
      }));
    } else {
      this.appStateUpdater.next(() => {
        const deepLinks = [...this.devTools.values()].filter(
        // Some tools do not use a string title, so we filter those out
        tool => !tool.enableRouting && !tool.isDisabled() && typeof tool.title === 'string').map(tool => ({
          id: tool.id,
          title: tool.title,
          path: `#/${tool.id}`
        }));
        return {
          deepLinks
        };
      });
    }
  }
  stop() {}
}
exports.DevToolsPlugin = DevToolsPlugin;