"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RANDOM_SAMPLER_STEP = exports.RANDOM_SAMPLER_SELECT_OPTIONS = exports.RANDOM_SAMPLER_PROBABILITIES = exports.RANDOM_SAMPLER_OPTION = exports.MIN_SAMPLER_PROBABILITY = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RANDOM_SAMPLER_PROBABILITIES = [0.00001, 0.00005, 0.0001, 0.0005, 0.001, 0.005, 0.01, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5].map(n => n * 100);
exports.RANDOM_SAMPLER_PROBABILITIES = RANDOM_SAMPLER_PROBABILITIES;
const MIN_SAMPLER_PROBABILITY = 0.00001;
exports.MIN_SAMPLER_PROBABILITY = MIN_SAMPLER_PROBABILITY;
const RANDOM_SAMPLER_STEP = MIN_SAMPLER_PROBABILITY * 100;
exports.RANDOM_SAMPLER_STEP = RANDOM_SAMPLER_STEP;
const RANDOM_SAMPLER_OPTION = {
  ON_AUTOMATIC: 'on_automatic',
  ON_MANUAL: 'on_manual',
  OFF: 'off'
};
exports.RANDOM_SAMPLER_OPTION = RANDOM_SAMPLER_OPTION;
const RANDOM_SAMPLER_SELECT_OPTIONS = [{
  'data-test-subj': 'dvRandomSamplerOptionOnAutomatic',
  value: RANDOM_SAMPLER_OPTION.ON_AUTOMATIC,
  text: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerPreference.onAutomaticLabel', {
    defaultMessage: 'On - automatic'
  })
}, {
  'data-test-subj': 'dvRandomSamplerOptionOnManual',
  value: RANDOM_SAMPLER_OPTION.ON_MANUAL,
  text: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerPreference.onManualLabel', {
    defaultMessage: 'On - manual'
  })
}, {
  'data-test-subj': 'dvRandomSamplerOptionOff',
  value: RANDOM_SAMPLER_OPTION.OFF,
  text: _i18n.i18n.translate('xpack.dataVisualizer.randomSamplerPreference.offLabel', {
    defaultMessage: 'Off'
  })
}];
exports.RANDOM_SAMPLER_SELECT_OPTIONS = RANDOM_SAMPLER_SELECT_OPTIONS;