"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultsView = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _file_contents = require("../file_contents");
var _analysis_summary = require("../analysis_summary");
var _fields_stats_grid = require("../../../common/components/fields_stats_grid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultsView = ({
  data,
  fileName,
  results,
  showEditFlyout,
  showExplanationFlyout,
  disableButtons
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    "data-test-subj": "dataVisualizerPageFileResults"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentHeader_Deprecated, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dataVisualizerFileResultsTitle"
  }, fileName))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "results"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "dataVisualizerFileFileContentPanel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_file_contents.FileContents, {
    data: data,
    format: results.format,
    numberOfLines: results.num_lines_analyzed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "dataVisualizerFileSummaryPanel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_analysis_summary.AnalysisSummary, {
    results: results
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => showEditFlyout(),
    disabled: disableButtons
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.overrideSettingsButtonLabel",
    defaultMessage: "Override settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => showExplanationFlyout(),
    disabled: disableButtons
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.analysisExplanationButtonLabel",
    defaultMessage: "Analysis explanation"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "dataVisualizerFileFileStatsPanel",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "dataVisualizerFileStatsTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.resultsView.fileStatsName",
    defaultMessage: "File stats"
  }))), /*#__PURE__*/_react.default.createElement(_fields_stats_grid.FieldsStatsGrid, {
    results: results
  }))));
};
exports.ResultsView = ResultsView;