"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = exports.EDITOR_MODE = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EDITOR_MODE = {
  TEXT: 'text',
  JSON: 'json',
  XJSON: new _shared_imports.XJsonMode()
};
exports.EDITOR_MODE = EDITOR_MODE;
const JsonEditor = ({
  value,
  height = '500px',
  width = '100%',
  mode = EDITOR_MODE.JSON,
  readOnly = false,
  syntaxChecking = true,
  theme = 'textmate',
  onChange = () => {}
}) => {
  if (mode === EDITOR_MODE.XJSON) {
    value = (0, _shared_imports.expandLiteralStrings)(value);
  }
  return /*#__PURE__*/_react.default.createElement(_shared_imports.EuiCodeEditor, {
    value: value,
    width: width,
    height: height,
    mode: mode,
    readOnly: readOnly,
    wrapEnabled: true,
    showPrintMargin: false,
    theme: theme,
    editorProps: {
      $blockScrolling: true
    },
    setOptions: {
      useWorker: syntaxChecking,
      tabSize: 2,
      useSoftTabs: true
    },
    onChange: onChange
  });
};
exports.JsonEditor = JsonEditor;