"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleSettings = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _combined_fields = require("../../../common/components/combined_fields");
var _create_data_view_tooltip = require("./create_data_view_tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SimpleSettings = ({
  index,
  initialized,
  onIndexChange,
  createDataView,
  onCreateDataViewChange,
  indexNameError,
  combinedFields,
  canCreateDataView
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.simpleImportSettings.indexNameFormRowLabel",
      defaultMessage: "Index name"
    }),
    isInvalid: indexNameError !== '',
    error: [indexNameError]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.simpleImportSettings.indexNamePlaceholder', {
      defaultMessage: 'index name'
    }),
    value: index,
    disabled: initialized === true,
    onChange: onIndexChange,
    isInvalid: indexNameError !== '',
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.simpleImportSettings.indexNameAriaLabel', {
      defaultMessage: 'Index name, required field'
    }),
    "data-test-subj": "dataVisualizerFileIndexNameInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_create_data_view_tooltip.CreateDataViewToolTip, {
    showTooltip: canCreateDataView === false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "createDataView",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.simpleImportSettings.createDataViewLabel",
      defaultMessage: "Create data view"
    }),
    checked: createDataView === true,
    disabled: initialized === true || canCreateDataView === false,
    onChange: onCreateDataViewChange,
    "data-test-subj": "dataVisualizerFileCreateDataViewCheckbox"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_combined_fields.CombinedFieldsReadOnlyForm, {
    combinedFields: combinedFields
  }));
};
exports.SimpleSettings = SimpleSettings;