"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileContents = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _json_editor = require("../json_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileContents = ({
  data,
  format,
  numberOfLines
}) => {
  let mode = _json_editor.EDITOR_MODE.TEXT;
  if (format === _json_editor.EDITOR_MODE.JSON) {
    mode = _json_editor.EDITOR_MODE.JSON;
  }
  const formattedData = limitByNumberOfLines(data, numberOfLines);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileContents.fileContentsTitle",
    defaultMessage: "File contents"
  }))), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileContents.firstLinesDescription",
    defaultMessage: "First {numberOfLines, plural, zero {# line} one {# line} other {# lines}}",
    values: {
      numberOfLines
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: mode,
    readOnly: true,
    value: formattedData,
    height: "200px",
    syntaxChecking: false
  }));
};
exports.FileContents = FileContents;
function limitByNumberOfLines(data, numberOfLines) {
  return data.split('\n').slice(0, numberOfLines).join('\n');
}