"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BottomBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../file_data_visualizer_view/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Bottom bar component for Data Visualizer page.
 */
const BottomBar = ({
  mode,
  onChangeMode,
  onCancel,
  disableImport
}) => {
  if (mode === _constants.MODE.READ) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: disableImport ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.bottomBar.missingImportPrivilegesMessage",
        defaultMessage: "You require the ingest_admin role to enable data importing"
      }) : null
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      isDisabled: disableImport,
      onClick: () => onChangeMode(_constants.MODE.IMPORT),
      "data-test-subj": "dataVisualizerFileOpenImportPageButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.bottomBar.readMode.importButtonLabel",
      defaultMessage: "Import"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "ghost",
      onClick: () => onCancel()
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.bottomBar.readMode.cancelButtonLabel",
      defaultMessage: "Cancel"
    })))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "ghost",
      onClick: () => onChangeMode(_constants.MODE.READ)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.bottomBar.backButtonLabel",
      defaultMessage: "Back"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "ghost",
      onClick: () => onCancel()
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.bottomBar.cancelButtonLabel",
      defaultMessage: "Cancel"
    })))));
  }
};
exports.BottomBar = BottomBar;