"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingPanel = exports.AboutPanel = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _welcome_content = require("./welcome_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AboutPanel = ({
  onFilePickerChange,
  hasPermissionToImport
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    paddingSize: "none",
    panelled: false,
    restrictWidth: 1000,
    "data-test-subj": "dataVisualizerPageFileUpload"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_welcome_content.WelcomeContent, {
    hasPermissionToImport: hasPermissionToImport
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "filePicker",
    initialPromptText: _i18n.i18n.translate('xpack.dataVisualizer.file.aboutPanel.selectOrDragAndDropFileDescription', {
      defaultMessage: 'Select or drag and drop a file'
    }),
    onChange: files => onFilePickerChange(files),
    className: "file-datavisualizer-file-picker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })))));
};
exports.AboutPanel = AboutPanel;
const LoadingPanel = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    restrictWidth: 400,
    "data-test-subj": "dataVisualizerPageFileLoading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    className: "file-datavisualizer-about-panel__content",
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    role: "alert"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.aboutPanel.analyzingDataTitle",
    defaultMessage: "Analyzing data"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })))));
};
exports.LoadingPanel = LoadingPanel;