"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kbnTypeToSupportedType = kbnTypeToSupportedType;
var _fieldTypes = require("@kbn/field-types");
var _public = require("@kbn/unified-field-list-plugin/public");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// convert kibana types to ML Job types
// this is needed because kibana types only have string and not text and keyword.
// and we can't use ES_FIELD_TYPES because it has no NUMBER type
function kbnTypeToSupportedType(field) {
  var _field$esTypes;
  // Return undefined if not one of the supported data visualizer field types.
  let type;
  switch (field.type) {
    case _fieldTypes.KBN_FIELD_TYPES.STRING:
      type = field.aggregatable ? _constants.SUPPORTED_FIELD_TYPES.KEYWORD : _constants.SUPPORTED_FIELD_TYPES.TEXT;
      if ((_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 && _field$esTypes.includes(_constants.SUPPORTED_FIELD_TYPES.VERSION)) {
        type = _constants.SUPPORTED_FIELD_TYPES.VERSION;
      }
      break;
    default:
      type = (0, _public.getFieldType)(field);
      break;
  }
  return type;
}