"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _examples_list = require("../../../examples_list");
var _expanded_row_content = require("./expanded_row_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextContent = ({
  config
}) => {
  const {
    stats
  } = config;
  if (stats === undefined) return null;
  const {
    examples
  } = stats;
  if (examples === undefined) return null;
  const numExamples = examples.length;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerTextContent'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "dvText__wrapper"
  }, numExamples > 0 && /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: examples
  }), numExamples === 0 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.fieldText.noExamplesForFieldsTitle', {
      defaultMessage: 'No examples were obtained for this field'
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldText.fieldNotPresentDescription",
    defaultMessage: "This field was not present in the {sourceParam} field of documents queried.",
    values: {
      sourceParam: /*#__PURE__*/_react.default.createElement("span", {
        className: "dvExpandedRow__codeContent"
      }, "_source")
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.fieldText.fieldMayBePopulatedDescription",
    defaultMessage: "It may be populated, for example, using a {copyToParam} parameter in the document mapping, or be pruned from the {sourceParam} field after indexing through the use of {includesParam} and {excludesParam} parameters.",
    values: {
      copyToParam: /*#__PURE__*/_react.default.createElement("span", {
        className: "dvExpandedRow__codeContent"
      }, "copy_to"),
      sourceParam: /*#__PURE__*/_react.default.createElement("span", {
        className: "dvExpandedRow__codeContent"
      }, "_source"),
      includesParam: /*#__PURE__*/_react.default.createElement("span", {
        className: "dvExpandedRow__codeContent"
      }, "includes"),
      excludesParam: /*#__PURE__*/_react.default.createElement("span", {
        className: "dvExpandedRow__codeContent"
      }, "excludes")
    }
  })))));
};
exports.TextContent = TextContent;