"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultDataVisualizerListState = exports.FieldsStatsGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _stats_table = require("../stats_table");
var _expanded_row = require("../expanded_row");
var _field_names_filter = require("../field_names_filter");
var _field_types_filter = require("../field_types_filter");
var _create_fields = require("./create_fields");
var _filter_fields = require("./filter_fields");
var _field_count_stats = require("../stats_table/components/field_count_stats");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultDataVisualizerListState = () => ({
  pageIndex: 0,
  pageSize: 25,
  sortField: 'fieldName',
  sortDirection: 'asc',
  visibleFieldTypes: [],
  visibleFieldNames: [],
  showDistributions: true
});
exports.getDefaultDataVisualizerListState = getDefaultDataVisualizerListState;
function getItemIdToExpandedRowMap(itemIds, items) {
  return itemIds.reduce((m, fieldName) => {
    const item = items.find(fieldVisConfig => fieldVisConfig.fieldName === fieldName);
    if (item !== undefined) {
      m[fieldName] = /*#__PURE__*/_react.default.createElement(_expanded_row.FileBasedDataVisualizerExpandedRow, {
        item: item
      });
    }
    return m;
  }, {});
}
const FieldsStatsGrid = ({
  results
}) => {
  var _dataVisualizerListSt, _dataVisualizerListSt2;
  const restorableDefaults = getDefaultDataVisualizerListState();
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _react.useState)(restorableDefaults);
  const visibleFieldTypes = (_dataVisualizerListSt = dataVisualizerListState.visibleFieldTypes) !== null && _dataVisualizerListSt !== void 0 ? _dataVisualizerListSt : restorableDefaults.visibleFieldTypes;
  const setVisibleFieldTypes = values => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      visibleFieldTypes: values
    });
  };
  const visibleFieldNames = (_dataVisualizerListSt2 = dataVisualizerListState.visibleFieldNames) !== null && _dataVisualizerListSt2 !== void 0 ? _dataVisualizerListSt2 : restorableDefaults.visibleFieldNames;
  const setVisibleFieldNames = values => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      visibleFieldNames: values
    });
  };
  const {
    fields,
    totalFieldsCount,
    totalMetricFieldsCount
  } = (0, _react.useMemo)(() => (0, _create_fields.createFields)(results), [results]);
  const {
    filteredFields,
    visibleFieldsCount,
    visibleMetricsCount
  } = (0, _react.useMemo)(() => (0, _filter_fields.filterFields)(fields, visibleFieldNames, visibleFieldTypes), [fields, visibleFieldNames, visibleFieldTypes]);
  const fieldsCountStats = {
    visibleFieldsCount,
    totalFieldsCount
  };
  const metricsStats = {
    visibleMetricsCount,
    totalMetricFieldsCount
  };
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    style: {
      marginLeft: 4
    },
    "data-test-subj": "dataVisualizerFieldCountPanel",
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_field_count_stats.TotalFieldsCount, {
    fieldsCountStats: fieldsCountStats
  }), /*#__PURE__*/_react.default.createElement(_field_count_stats.MetricFieldsCount, {
    metricsStats: metricsStats
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": "dataVisualizerFieldCountPanel",
    justifyContent: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_field_names_filter.DataVisualizerFieldNamesFilter, {
    fields: fields,
    setVisibleFieldNames: setVisibleFieldNames,
    visibleFieldNames: visibleFieldNames
  }), /*#__PURE__*/_react.default.createElement(_field_types_filter.DataVisualizerFieldTypesFilter, {
    fields: fields,
    setVisibleFieldTypes: setVisibleFieldTypes,
    visibleFieldTypes: visibleFieldTypes
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_stats_table.DataVisualizerTable, {
    items: filteredFields,
    pageState: dataVisualizerListState,
    updatePageState: setDataVisualizerListState,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    overallStatsRunning: false
  }));
};
exports.FieldsStatsGrid = FieldsStatsGrid;