"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointContentWithMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expanded_row_content = require("../../stats_table/components/field_data_expanded_row/expanded_row_content");
var _document_stats = require("../../stats_table/components/field_data_expanded_row/document_stats");
var _examples_list = require("../../examples_list");
var _kibana_context = require("../../../../kibana_context");
var _constants = require("../../../../../../common/constants");
var _embedded_map = require("../../embedded_map");
var _expanded_row_panel = require("../../stats_table/components/field_data_expanded_row/expanded_row_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GeoPointContentWithMap = ({
  config,
  dataView,
  combinedQuery
}) => {
  const {
    stats
  } = config;
  const [layerList, setLayerList] = (0, _react.useState)([]);
  const {
    services: {
      maps: mapsPlugin,
      data
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();

  // Update the layer list  with updated geo points upon refresh
  (0, _react.useEffect)(() => {
    async function updateIndexPatternSearchLayer() {
      if ((dataView === null || dataView === void 0 ? void 0 : dataView.id) !== undefined && config !== undefined && config.fieldName !== undefined && (config.type === _constants.SUPPORTED_FIELD_TYPES.GEO_POINT || config.type === _constants.SUPPORTED_FIELD_TYPES.GEO_SHAPE)) {
        var _data$query$filterMan;
        const params = {
          indexPatternId: dataView.id,
          geoFieldName: config.fieldName,
          geoFieldType: config.type,
          filters: (_data$query$filterMan = data.query.filterManager.getFilters()) !== null && _data$query$filterMan !== void 0 ? _data$query$filterMan : [],
          query: {
            query: combinedQuery.searchString,
            language: combinedQuery.searchQueryLanguage
          }
        };
        const searchLayerDescriptor = mapsPlugin ? await mapsPlugin.createLayerDescriptors.createESSearchSourceLayerDescriptor(params) : null;
        if (searchLayerDescriptor) {
          setLayerList([...layerList, searchLayerDescriptor]);
        }
      }
    }
    updateIndexPatternSearchLayer();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataView, combinedQuery, config, mapsPlugin, data.query]);
  if ((stats === null || stats === void 0 ? void 0 : stats.examples) === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerIndexBasedMapContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: stats === null || stats === void 0 ? void 0 : stats.examples
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvMap__wrapper',
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_embedded_map.EmbeddedMapComponent, {
    layerList: layerList
  })));
};
exports.GeoPointContentWithMap = GeoPointContentWithMap;