"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeoPointsLayer = exports.convertWKTGeoToLonLat = exports.DEFAULT_POINT_COLOR = void 0;
var _eui = require("@elastic/eui");
var _common = require("@kbn/maps-plugin/common");
var _geo_point_content = require("./geo_point_content");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertWKTGeoToLonLat = value => {
  if (typeof value === 'string') {
    var _parsed$groups, _parsed$groups2;
    const trimmedValue = value.trim().replace('POINT (', '').replace(')', '');
    const regExpSerializer = _geo_point_content.DEFAULT_GEO_REGEX;
    const parsed = regExpSerializer.exec(trimmedValue.trim());
    if ((parsed === null || parsed === void 0 ? void 0 : (_parsed$groups = parsed.groups) === null || _parsed$groups === void 0 ? void 0 : _parsed$groups.lat) != null && (parsed === null || parsed === void 0 ? void 0 : (_parsed$groups2 = parsed.groups) === null || _parsed$groups2 === void 0 ? void 0 : _parsed$groups2.lon) != null) {
      return {
        lat: parseFloat(parsed.groups.lat.trim()),
        lon: parseFloat(parsed.groups.lon.trim())
      };
    }
  }
};
exports.convertWKTGeoToLonLat = convertWKTGeoToLonLat;
const DEFAULT_POINT_COLOR = (0, _eui.euiPaletteColorBlind)()[0];
exports.DEFAULT_POINT_COLOR = DEFAULT_POINT_COLOR;
const getGeoPointsLayer = (features, pointColor = DEFAULT_POINT_COLOR) => {
  return {
    id: 'geo_points',
    label: 'Geo points',
    sourceDescriptor: {
      type: _common.SOURCE_TYPES.GEOJSON_FILE,
      __featureCollection: {
        features,
        type: 'FeatureCollection'
      }
    },
    visible: true,
    style: {
      type: 'VECTOR',
      properties: {
        fillColor: {
          type: 'STATIC',
          options: {
            color: pointColor
          }
        },
        lineColor: {
          type: 'STATIC',
          options: {
            color: '#fff'
          }
        },
        lineWidth: {
          type: 'STATIC',
          options: {
            size: 2
          }
        },
        iconSize: {
          type: 'STATIC',
          options: {
            size: 6
          }
        }
      }
    },
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
};
exports.getGeoPointsLayer = getGeoPointsLayer;