"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMapComponent = EmbeddedMapComponent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/maps-plugin/common");
var _public = require("@kbn/maps-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _kibana_context = require("../../../kibana_context");
require("./_embedded_map.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EmbeddedMapComponent({
  layerList,
  mapEmbeddableInput,
  renderTooltipContent
}) {
  const [embeddable, setEmbeddable] = (0, _react.useState)();
  const embeddableRoot = (0, _react.useRef)(null);
  const baseLayers = (0, _react.useRef)();
  const {
    services: {
      embeddable: embeddablePlugin,
      maps: mapsPlugin,
      data
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const factory = embeddablePlugin ? embeddablePlugin.getEmbeddableFactory(_public.MAP_SAVED_OBJECT_TYPE) : undefined;

  // Update the layer list  with updated geo points upon refresh
  (0, _react.useEffect)(() => {
    async function updateIndexPatternSearchLayer() {
      if (embeddable && !(0, _public2.isErrorEmbeddable)(embeddable) && Array.isArray(layerList) && Array.isArray(baseLayers.current)) {
        embeddable.setLayerList([...baseLayers.current, ...layerList]);
      }
    }
    updateIndexPatternSearchLayer();
  }, [embeddable, layerList]);
  (0, _react.useEffect)(() => {
    async function setupEmbeddable() {
      var _data$query$filterMan;
      if (!factory) {
        // eslint-disable-next-line no-console
        console.error('Map embeddable not found.');
        return;
      }
      const input = {
        id: (0, _eui.htmlIdGenerator)()(),
        attributes: {
          title: ''
        },
        filters: (_data$query$filterMan = data.query.filterManager.getFilters()) !== null && _data$query$filterMan !== void 0 ? _data$query$filterMan : [],
        hidePanelTitles: true,
        viewMode: _public2.ViewMode.VIEW,
        isLayerTOCOpen: false,
        hideFilterActions: true,
        // can use mapSettings to center map on anomalies
        mapSettings: {
          disableInteractive: false,
          hideToolbarOverlay: false,
          hideLayerControl: false,
          hideViewControl: false,
          initialLocation: _common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
          // this will startup based on data-extent
          autoFitToDataBounds: true // this will auto-fit when there are changes to the filter and/or query
        }
      };

      const embeddableObject = await factory.create(input);
      if (embeddableObject && !(0, _public2.isErrorEmbeddable)(embeddableObject)) {
        const basemapLayerDescriptor = mapsPlugin ? await mapsPlugin.createLayerDescriptors.createBasemapLayerDescriptor() : null;
        if (basemapLayerDescriptor) {
          baseLayers.current = [basemapLayerDescriptor];
          await embeddableObject.setLayerList(baseLayers.current);
        }
      }
      setEmbeddable(embeddableObject);
    }
    setupEmbeddable();
    // we want this effect to execute exactly once after the component mounts
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (embeddable && !(0, _public2.isErrorEmbeddable)(embeddable) && mapEmbeddableInput !== undefined) {
      embeddable.updateInput(mapEmbeddableInput);
    }
  }, [embeddable, mapEmbeddableInput]);
  (0, _react.useEffect)(() => {
    if (embeddable && !(0, _public2.isErrorEmbeddable)(embeddable) && renderTooltipContent !== undefined) {
      embeddable.setRenderTooltipContent(renderTooltipContent);
    }
  }, [embeddable, renderTooltipContent]);

  // We can only render after embeddable has already initialized
  (0, _react.useEffect)(() => {
    if (embeddableRoot.current && embeddable) {
      embeddable.render(embeddableRoot.current);
    }
  }, [embeddable, embeddableRoot]);
  if (!embeddablePlugin) {
    // eslint-disable-next-line no-console
    console.error('Embeddable start plugin not found');
    return null;
  }
  if (!mapsPlugin) {
    // eslint-disable-next-line no-console
    console.error('Maps start plugin not found');
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dataVisualizerEmbeddedMapContent",
    className: "embeddedMap__content",
    ref: embeddableRoot
  });
}