"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HasData = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class HasData {
  constructor() {
    (0, _defineProperty2.default)(this, "removeAliases", source => !source.item.indices);
    (0, _defineProperty2.default)(this, "isUserDataSource", source => {
      // filter out indices that start with `.`
      if (source.name.startsWith('.')) return false;

      // filter out sources from DEFAULT_ASSETS_TO_IGNORE
      if (_common.DEFAULT_ASSETS_TO_IGNORE.DATA_STREAMS_TO_IGNORE.includes(source.name)) return false; // filter out data streams that we know are created automatically during on-boarding

      return true;
    });
    // ES Data
    (0, _defineProperty2.default)(this, "responseToItemArray", response => {
      const {
        indices = [],
        aliases = []
      } = response;
      const source = [];
      [...indices, ...aliases, ...(response.data_streams || [])].forEach(item => {
        source.push({
          name: item.name,
          item
        });
      });
      return source;
    });
    (0, _defineProperty2.default)(this, "getIndicesViaSearch", async ({
      http,
      pattern,
      showAllIndices
    }) => http.post(`/internal/search/ese`, {
      body: JSON.stringify({
        params: {
          ignore_unavailable: true,
          expand_wildcards: showAllIndices ? 'all' : 'open',
          index: pattern,
          body: {
            size: 0,
            // no hits
            aggs: {
              indices: {
                terms: {
                  field: '_index',
                  size: 200
                }
              }
            }
          }
        }
      })
    }).then(resp => {
      return !!(resp && resp.total >= 0);
    }).catch(e => {
      // eslint-disable-next-line no-console
      console.warn(`getIndicesViaSearch failed with error, assuming there is data`, e);
      return true;
    }));
    (0, _defineProperty2.default)(this, "getIndices", async ({
      http,
      pattern,
      showAllIndices
    }) => http.get(`/internal/index-pattern-management/resolve_index/${pattern}`, {
      query: showAllIndices ? {
        expand_wildcards: 'all'
      } : undefined
    }).then(response => {
      if (!response) {
        return [];
      } else {
        return this.responseToItemArray(response);
      }
    }));
    (0, _defineProperty2.default)(this, "checkLocalESData", http => this.getIndices({
      http,
      pattern: '*',
      showAllIndices: false
    }).then(dataSources => {
      return dataSources.some(this.isUserDataSource);
    }).catch(() => this.getIndicesViaSearch({
      http,
      pattern: '*',
      showAllIndices: false
    })));
    (0, _defineProperty2.default)(this, "checkRemoteESData", http => this.getIndices({
      http,
      pattern: '*:*',
      showAllIndices: false
    }).then(dataSources => {
      return !!dataSources.filter(this.removeAliases).length;
    }).catch(() => this.getIndicesViaSearch({
      http,
      pattern: '*:*',
      showAllIndices: false
    })));
    // Data Views
    (0, _defineProperty2.default)(this, "getHasDataViews", async ({
      http
    }) => http.get(`/internal/data_views/has_data_views`));
    (0, _defineProperty2.default)(this, "hasDataViews", http => {
      return this.getHasDataViews({
        http
      }).then(response => {
        const {
          hasDataView
        } = response;
        return hasDataView;
      }).catch(e => {
        // eslint-disable-next-line no-console
        console.warn(`hasDataViews failed with error, assuming there are data views`, e);
        return true;
      });
    });
    (0, _defineProperty2.default)(this, "hasUserDataViews", http => {
      return this.getHasDataViews({
        http
      }).then(response => {
        const {
          hasUserDataView
        } = response;
        return hasUserDataView;
      }).catch(e => {
        // eslint-disable-next-line no-console
        console.warn(`hasUserDataViews failed with error, assuming there are user-created data views`, e);
        return true;
      });
    });
  }
  start(core) {
    const {
      http
    } = core;
    return {
      /**
       * Check to see if ES data exists
       */
      hasESData: async () => {
        const hasLocalESData = await this.checkLocalESData(http);
        if (!hasLocalESData) {
          const hasRemoteESData = await this.checkRemoteESData(http);
          return hasRemoteESData;
        }
        return hasLocalESData;
      },
      /**
       * Check to see if a data view exists
       */
      hasDataView: async () => {
        const dataViewsCheck = await this.hasDataViews(http);
        return dataViewsCheck;
      },
      /**
       * Check to see if user created data views exist
       */
      hasUserDataView: async () => {
        const userDataViewsCheck = await this.hasUserDataViews(http);
        return userDataViewsCheck;
      }
    };
  }
}
exports.HasData = HasData;