"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsClientPublicToCommon = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _errors = require("../common/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const simpleSavedObjectToSavedObject = simpleSavedObject => ({
  version: simpleSavedObject._version,
  ...(0, _lodash.omit)(simpleSavedObject, '_version')
});
class SavedObjectsClientPublicToCommon {
  constructor(savedObjectClient) {
    (0, _defineProperty2.default)(this, "savedObjectClient", void 0);
    this.savedObjectClient = savedObjectClient;
  }
  async find(options) {
    const response = (await this.savedObjectClient.find(options)).savedObjects;
    return response.map(simpleSavedObjectToSavedObject);
  }
  async get(type, id) {
    const response = await this.savedObjectClient.resolve(type, id);
    if (response.outcome === 'conflict') {
      throw new _errors.DataViewSavedObjectConflictError(id);
    }
    return simpleSavedObjectToSavedObject(response.saved_object);
  }
  async update(type, id, attributes, options) {
    const response = await this.savedObjectClient.update(type, id, attributes, options);
    return simpleSavedObjectToSavedObject(response);
  }
  async create(type, attributes, options) {
    const response = await this.savedObjectClient.create(type, attributes, options);
    return simpleSavedObjectToSavedObject(response);
  }
  delete(type, id) {
    return this.savedObjectClient.delete(type, id, {
      force: true
    });
  }
}
exports.SavedObjectsClientPublicToCommon = SavedObjectsClientPublicToCommon;