"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _expressions = require("./expressions");
var _ = require(".");
var _saved_objects_client_wrapper = require("./saved_objects_client_wrapper");
var _ui_settings_wrapper = require("./ui_settings_wrapper");
var _data_views_service_public = require("./data_views_service_public");
var _services = require("./services");
var _debounce_by_key = require("./debounce_by_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DataViewsPublicPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "hasData", new _services.HasData());
  }
  setup(core, {
    expressions
  }) {
    expressions.registerFunction((0, _expressions.getIndexPatternLoad)({
      getStartServices: core.getStartServices
    }));
    return {};
  }
  start(core, {
    fieldFormats
  }) {
    const {
      uiSettings,
      http,
      notifications,
      savedObjects,
      application
    } = core;
    const onNotifDebounced = (0, _debounce_by_key.debounceByKey)(notifications.toasts.add.bind(notifications.toasts), 10000);
    const onErrorDebounced = (0, _debounce_by_key.debounceByKey)(notifications.toasts.addError.bind(notifications.toasts), 10000);
    return new _data_views_service_public.DataViewsServicePublic({
      hasData: this.hasData.start(core),
      uiSettings: new _ui_settings_wrapper.UiSettingsPublicToCommon(uiSettings),
      savedObjectsClient: new _saved_objects_client_wrapper.SavedObjectsClientPublicToCommon(savedObjects.client),
      apiClient: new _.DataViewsApiClient(http),
      fieldFormats,
      onNotification: (toastInputFields, key) => {
        onNotifDebounced(key)(toastInputFields);
      },
      onError: (error, toastInputFields, key) => {
        onErrorDebounced(key)(error, toastInputFields);
      },
      getCanSave: () => Promise.resolve(application.capabilities.indexPatterns.save === true),
      getCanSaveSync: () => application.capabilities.indexPatterns.save === true,
      getCanSaveAdvancedSettings: () => Promise.resolve(application.capabilities.advancedSettings.save === true),
      getIndices: props => (0, _services.getIndices)({
        ...props,
        http: core.http
      })
    });
  }
  stop() {}
}
exports.DataViewsPublicPlugin = DataViewsPublicPlugin;