"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = exports.IPM_APP_ID = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const sectionsHeader = _i18n.i18n.translate('indexPatternManagement.dataView.sectionsHeader', {
  defaultMessage: 'Data Views'
});
const IPM_APP_ID = 'dataViews';
exports.IPM_APP_ID = IPM_APP_ID;
class IndexPatternManagementPlugin {
  constructor(initializerContext) {}
  setup(core, {
    management,
    urlForwarding
  }) {
    const kibanaSection = management.sections.section.kibana;
    if (!kibanaSection) {
      throw new Error('`kibana` management section not found.');
    }
    const newAppPath = `management/kibana/${IPM_APP_ID}`;
    const legacyPatternsPath = 'management/kibana/index_patterns';
    urlForwarding.forwardApp('management/kibana/index_pattern', newAppPath, path => '/create');
    urlForwarding.forwardApp(legacyPatternsPath, newAppPath, path => {
      const pathInApp = path.substr(legacyPatternsPath.length + 1);
      return pathInApp && `/patterns${pathInApp}`;
    });
    kibanaSection.registerApp({
      id: IPM_APP_ID,
      title: sectionsHeader,
      order: 0,
      capabilitiesId: 'indexPatterns',
      redirectFrom: 'kibana/indexPatterns',
      mount: async params => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_app')));
        return mountManagementSection(core.getStartServices, params);
      }
    });
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;