"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptingWarningCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ScriptingWarningCallOut = ({
  isVisible = false
}) => {
  var _useKibana$services$d;
  const docLinks = (_useKibana$services$d = (0, _public.useKibana)().services.docLinks) === null || _useKibana$services$d === void 0 ? void 0 : _useKibana$services$d.links;
  return isVisible ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.warningCallOutLabel.callOutDetail",
    defaultMessage: "Familiarize yourself with {scripFields} and {scriptsInAggregation} before using this feature. Scripted fields can be used to display and aggregate calculated values. As such, they can be very slow and, if done incorrectly, can cause Kibana to become unusable.",
    values: {
      scripFields: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinks.scriptedFields.scriptFields
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.warningCallOutLabel.scripFieldsLink",
        defaultMessage: "scripted fields"
      })),
      scriptsInAggregation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinks.scriptedFields.scriptAggs
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.warningCallOutLabel.scriptsInAggregationLink",
        defaultMessage: "scripts in aggregations"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.scriptedFieldsDeprecatedTitle",
      defaultMessage: "Scripted fields are deprecated",
      description: "Deprecation warning title within scripted field editor"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.scriptedFieldsDeprecatedBody",
    defaultMessage: "For greater flexibility and Painless script support, use {runtimeDocs}.",
    values: {
      runtimeDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: docLinks.runtimeFields.overview
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.warningCallOutLabel.runtimeLink",
        defaultMessage: "runtime fields"
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
};
exports.ScriptingWarningCallOut = ScriptingWarningCallOut;
ScriptingWarningCallOut.displayName = 'ScriptingWarningCallOut';