"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFormatEditor = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// use memoize to get stable reference
const unwrapEditor = (0, _lodash.memoize)(editorFactory => {
  if (!editorFactory) return null;
  return /*#__PURE__*/_react.default.lazy(() => editorFactory().then(editor => ({
    default: editor
  })));
});
class FieldFormatEditor extends _react.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      EditorComponent: unwrapEditor(props.fieldFormatEditors.getById(props.fieldFormatId))
    };
  }
  static getDerivedStateFromProps(nextProps) {
    return {
      EditorComponent: unwrapEditor(nextProps.fieldFormatEditors.getById(nextProps.fieldFormatId))
    };
  }
  render() {
    const {
      EditorComponent
    } = this.state;
    const {
      fieldType,
      fieldFormat,
      fieldFormatParams,
      onChange,
      onError
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, EditorComponent ? /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
      fallback:
      /*#__PURE__*/
      // We specify minHeight to avoid too mitigate layout shifts while loading an editor
      // ~430 corresponds to "4 lines" of EuiLoadingContent
      _react.default.createElement("div", {
        style: {
          minHeight: 430,
          marginTop: 8
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
        lines: 4
      })))
    }, /*#__PURE__*/_react.default.createElement(EditorComponent, {
      fieldType: fieldType,
      format: fieldFormat,
      formatParams: fieldFormatParams,
      onChange: onChange,
      onError: onError
    })) : null);
  }
}
exports.FieldFormatEditor = FieldFormatEditor;