"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = Tabs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/data-views-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _edit_index_pattern_state_container = require("../edit_index_pattern_state_container");
var _constants = require("../constants");
var _source_filters_table = require("../source_filters_table");
var _indexed_fields_table = require("../indexed_fields_table");
var _scripted_fields_table = require("../scripted_fields_table");
var _relationships_table = require("../relationships_table");
var _utils = require("./utils");
var _utils2 = require("../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const searchAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.searchAria', {
  defaultMessage: 'Search fields'
});
const filterLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.filter', {
  defaultMessage: 'Field type'
});
const filterAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.filterAria', {
  defaultMessage: 'Filter field types'
});
const schemaFilterLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.schema', {
  defaultMessage: 'Schema type'
});
const schemaAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.schemaAria', {
  defaultMessage: 'Filter schema types'
});
const scriptedFieldFilterLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.scriptedFieldFilter', {
  defaultMessage: 'All languages'
});
const scriptedFieldAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.scriptedFieldFilterAria', {
  defaultMessage: 'Filter scripted field languages'
});
const schemaOptionRuntime = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.runtime', {
  defaultMessage: 'Runtime'
});
const schemaOptionIndexed = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.indexed', {
  defaultMessage: 'Indexed'
});
const filterPlaceholder = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.filterPlaceholder', {
  defaultMessage: 'Search'
});
const addFieldButtonLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.addFieldButtonLabel', {
  defaultMessage: 'Add field'
});
function Tabs({
  indexPattern,
  saveIndexPattern,
  fields,
  history,
  refreshFields,
  relationships,
  allowedTypes,
  compositeRuntimeFields
}) {
  const {
    uiSettings,
    docLinks,
    dataViewFieldEditor,
    overlays,
    theme,
    dataViews,
    http,
    application,
    savedObjectsManagement
  } = (0, _public3.useKibana)().services;
  const [fieldFilter, setFieldFilter] = (0, _react.useState)('');
  const [syncingStateFunc, setSyncingStateFunc] = (0, _react.useState)({
    getCurrentTab: () => _constants.TAB_INDEXED_FIELDS
  });
  const [scriptedFieldLanguageFilter, setScriptedFieldLanguageFilter] = (0, _react.useState)([]);
  const [isScriptedFieldFilterOpen, setIsScriptedFieldFilterOpen] = (0, _react.useState)(false);
  const [scriptedFieldLanguages, setScriptedFieldLanguages] = (0, _react.useState)([]);
  const [indexedFieldTypeFilter, setIndexedFieldTypeFilter] = (0, _react.useState)([]);
  const [isIndexedFilterOpen, setIsIndexedFilterOpen] = (0, _react.useState)(false);
  const [indexedFieldTypes, setIndexedFieldTypes] = (0, _react.useState)([]);
  const [schemaFieldTypeFilter, setSchemaFieldTypeFilter] = (0, _react.useState)([]);
  const [isSchemaFilterOpen, setIsSchemaFilterOpen] = (0, _react.useState)(false);
  const [schemaItems, setSchemaItems] = (0, _react.useState)([{
    value: 'runtime',
    name: schemaOptionRuntime
  }, {
    value: 'indexed',
    name: schemaOptionIndexed
  }]);
  const closeEditorHandler = (0, _react.useRef)();
  const {
    DeleteRuntimeFieldProvider
  } = dataViewFieldEditor;
  const updateFilterItem = (items, index, updater) => {
    if (!items[index]) {
      return;
    }
    const newItems = [...items];
    switch (newItems[index].checked) {
      case 'on':
        newItems[index].checked = undefined;
        break;
      default:
        newItems[index].checked = 'on';
    }
    updater(newItems);
  };
  const refreshFilters = (0, _react.useCallback)(() => {
    const tempIndexedFieldTypes = [];
    const tempScriptedFieldLanguages = [];
    indexPattern.fields.getAll().forEach(field => {
      if (field.scripted) {
        if (field.lang) {
          tempScriptedFieldLanguages.push(field.lang);
        }
      } else {
        // for conflicted fields, add conflict as a type
        if (field.type === 'conflict') {
          tempIndexedFieldTypes.push('conflict');
        }
        if (field.esTypes) {
          // add all types, may be multiple
          field.esTypes.forEach(item => tempIndexedFieldTypes.push(item));
        }
      }
    });
    setIndexedFieldTypes((0, _utils.convertToEuiFilterOptions)(tempIndexedFieldTypes));
    setScriptedFieldLanguages((0, _utils.convertToEuiFilterOptions)(tempScriptedFieldLanguages));
  }, [indexPattern]);
  const closeFieldEditor = (0, _react.useCallback)(() => {
    if (closeEditorHandler.current) {
      closeEditorHandler.current();
    }
  }, []);
  const openFieldEditor = (0, _react.useCallback)(fieldName => {
    closeEditorHandler.current = dataViewFieldEditor.openEditor({
      ctx: {
        dataView: indexPattern
      },
      onSave: refreshFields,
      fieldName
    });
  }, [dataViewFieldEditor, indexPattern, refreshFields]);
  (0, _react.useEffect)(() => {
    refreshFilters();
  }, [indexPattern, indexPattern.fields, refreshFilters]);
  (0, _react.useEffect)(() => {
    return () => {
      // When the component unmounts, make sure to close the field editor
      closeFieldEditor();
    };
  }, [closeFieldEditor]);
  const fieldWildcardMatcherDecorated = (0, _react.useCallback)(filters => (0, _public.fieldWildcardMatcher)(filters, uiSettings.get(_public2.META_FIELDS)), [uiSettings]);
  const userEditPermission = dataViews.getCanSaveSync();
  const getFilterSection = (0, _react.useCallback)(type => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      fullWidth: true,
      placeholder: filterPlaceholder,
      value: fieldFilter,
      onChange: e => setFieldFilter(e.target.value),
      "data-test-subj": "indexPatternFieldFilter",
      "aria-label": searchAriaLabel
    })), type === _constants.TAB_INDEXED_FIELDS && indexedFieldTypes.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downCenter",
      "data-test-subj": "indexedFieldTypeFilterDropdown-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
        "aria-label": filterAriaLabel,
        "data-test-subj": "indexedFieldTypeFilterDropdown",
        iconType: "arrowDown",
        onClick: () => setIsIndexedFilterOpen(!isIndexedFilterOpen),
        isSelected: isIndexedFilterOpen,
        numFilters: indexedFieldTypes.length,
        hasActiveFilters: !!indexedFieldTypes.find(item => item.checked === 'on'),
        numActiveFilters: indexedFieldTypes.filter(item => item.checked === 'on').length
      }, filterLabel),
      isOpen: isIndexedFilterOpen,
      closePopover: () => setIsIndexedFilterOpen(false)
    }, indexedFieldTypes.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: item.checked,
      key: item.value,
      onClick: () => {
        setIndexedFieldTypeFilter(item.checked ? indexedFieldTypeFilter.filter(f => f !== item.value) : [...indexedFieldTypeFilter, item.value]);
        updateFilterItem(indexedFieldTypes, index, setIndexedFieldTypes);
      },
      "data-test-subj": `indexedFieldTypeFilterDropdown-option-${item.value}${item.checked ? '-checked' : ''}`
    }, item.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downCenter",
      "data-test-subj": "schemaFieldTypeFilterDropdown-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
        "aria-label": schemaAriaLabel,
        "data-test-subj": "schemaFieldTypeFilterDropdown",
        iconType: "arrowDown",
        onClick: () => setIsSchemaFilterOpen(!isSchemaFilterOpen),
        isSelected: isSchemaFilterOpen,
        numFilters: schemaItems.length,
        hasActiveFilters: !!schemaItems.find(item => item.checked === 'on'),
        numActiveFilters: schemaItems.filter(item => item.checked === 'on').length
      }, schemaFilterLabel),
      isOpen: isSchemaFilterOpen,
      closePopover: () => setIsSchemaFilterOpen(false)
    }, schemaItems.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: item.checked,
      key: item.value,
      onClick: () => {
        setSchemaFieldTypeFilter(item.checked ? schemaFieldTypeFilter.filter(f => f !== item.value) : [...schemaFieldTypeFilter, item.value]);
        updateFilterItem(schemaItems, index, setSchemaItems);
      },
      "data-test-subj": `schemaFieldTypeFilterDropdown-option-${item.value}${item.checked ? '-checked' : ''}`
    }, item.name))))), userEditPermission && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: () => openFieldEditor(),
      "data-test-subj": "addField"
    }, addFieldButtonLabel))), type === _constants.TAB_SCRIPTED_FIELDS && scriptedFieldLanguages.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downCenter",
      "data-test-subj": "scriptedFieldLanguageFilterDropdown-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
        "aria-label": scriptedFieldAriaLabel,
        "data-test-subj": "scriptedFieldLanguageFilterDropdown",
        iconType: "arrowDown",
        onClick: () => setIsScriptedFieldFilterOpen(!isScriptedFieldFilterOpen),
        isSelected: isScriptedFieldFilterOpen,
        numFilters: scriptedFieldLanguages.length,
        hasActiveFilters: !!scriptedFieldLanguages.find(item => item.checked === 'on'),
        numActiveFilters: scriptedFieldLanguages.filter(item => item.checked === 'on').length
      }, scriptedFieldFilterLabel),
      isOpen: isScriptedFieldFilterOpen,
      closePopover: () => setIsScriptedFieldFilterOpen(false)
    }, scriptedFieldLanguages.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: item.checked,
      key: item.value,
      onClick: () => {
        setScriptedFieldLanguageFilter(item.checked ? scriptedFieldLanguageFilter.filter(f => f !== item.value) : [...scriptedFieldLanguageFilter, item.value]);
        updateFilterItem(scriptedFieldLanguages, index, setScriptedFieldLanguages);
      },
      "data-test-subj": `scriptedFieldLanguageFilterDropdown-option-${item.value}${item.checked ? '-checked' : ''}`
    }, item.name))))));
  }, [fieldFilter, indexedFieldTypeFilter, indexedFieldTypes, isIndexedFilterOpen, scriptedFieldLanguageFilter, scriptedFieldLanguages, isScriptedFieldFilterOpen, schemaItems, schemaFieldTypeFilter, isSchemaFilterOpen, openFieldEditor, userEditPermission]);
  const getContent = (0, _react.useCallback)(type => {
    switch (type) {
      case _constants.TAB_INDEXED_FIELDS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), getFilterSection(type), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(DeleteRuntimeFieldProvider, {
          dataView: indexPattern,
          onDelete: refreshFields
        }, deleteField => /*#__PURE__*/_react.default.createElement(_indexed_fields_table.IndexedFieldsTable, {
          fields: fields,
          compositeRuntimeFields: compositeRuntimeFields,
          indexPattern: indexPattern,
          fieldFilter: fieldFilter,
          fieldWildcardMatcher: fieldWildcardMatcherDecorated,
          indexedFieldTypeFilter: indexedFieldTypeFilter,
          schemaFieldTypeFilter: schemaFieldTypeFilter,
          helpers: {
            editField: openFieldEditor,
            deleteField,
            getFieldInfo: _utils2.getFieldInfo
          },
          openModal: overlays.openModal,
          theme: theme,
          userEditPermission: dataViews.getCanSaveSync()
        })));
      case _constants.TAB_SCRIPTED_FIELDS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), getFilterSection(type), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(_scripted_fields_table.ScriptedFieldsTable, {
          indexPattern: indexPattern,
          saveIndexPattern: saveIndexPattern,
          fieldFilter: fieldFilter,
          scriptedFieldLanguageFilter: scriptedFieldLanguageFilter,
          helpers: {
            redirectToRoute: field => {
              history.push((0, _utils.getPath)(field, indexPattern));
            }
          },
          onRemoveField: refreshFilters,
          painlessDocLink: docLinks.links.scriptedFields.painless,
          userEditPermission: dataViews.getCanSaveSync()
        }));
      case _constants.TAB_SOURCE_FILTERS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), getFilterSection(type), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(_source_filters_table.SourceFiltersTable, {
          saveIndexPattern: saveIndexPattern,
          indexPattern: indexPattern,
          filterFilter: fieldFilter,
          fieldWildcardMatcher: fieldWildcardMatcherDecorated,
          onAddOrRemoveFilter: refreshFilters
        }));
      case _constants.TAB_RELATIONSHIPS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(_relationships_table.RelationshipsTable, {
          basePath: http.basePath,
          id: indexPattern.id,
          capabilities: application.capabilities,
          relationships: relationships,
          allowedTypes: allowedTypes,
          navigateToUrl: application.navigateToUrl,
          getDefaultTitle: savedObjectsManagement.getDefaultTitle,
          getSavedObjectLabel: savedObjectsManagement.getSavedObjectLabel
        }));
    }
  }, [docLinks.links.scriptedFields.painless, fieldFilter, fieldWildcardMatcherDecorated, fields, getFilterSection, history, indexPattern, indexedFieldTypeFilter, schemaFieldTypeFilter, refreshFilters, scriptedFieldLanguageFilter, saveIndexPattern, openFieldEditor, DeleteRuntimeFieldProvider, refreshFields, overlays, theme, dataViews, compositeRuntimeFields, http, application, savedObjectsManagement, allowedTypes, relationships]);
  const euiTabs = (0, _react.useMemo)(() => (0, _utils.getTabs)(indexPattern, fieldFilter, relationships.length).map(tab => {
    return {
      ...tab,
      content: getContent(tab.id)
    };
  }), [fieldFilter, getContent, indexPattern, relationships]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(euiTabs[0].id);
  (0, _react.useEffect)(() => {
    const {
      startSyncingState,
      stopSyncingState,
      setCurrentTab,
      getCurrentTab
    } = (0, _edit_index_pattern_state_container.createEditIndexPatternPageStateContainer)({
      useHashedUrl: uiSettings.get('state:storeInSessionStorage'),
      defaultTab: _constants.TAB_INDEXED_FIELDS
    });
    startSyncingState();
    setSyncingStateFunc({
      setCurrentTab,
      getCurrentTab
    });
    setSelectedTabId(getCurrentTab());
    return () => {
      stopSyncingState();
    };
  }, [uiSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: euiTabs,
    selectedTab: euiTabs.find(tab => tab.id === selectedTabId),
    onTabClick: tab => {
      var _syncingStateFunc$set;
      setSelectedTabId(tab.id);
      (_syncingStateFunc$set = syncingStateFunc.setCurrentTab) === null || _syncingStateFunc$set === void 0 ? void 0 : _syncingStateFunc$set.call(syncingStateFunc, tab.id);
    }
  });
}