"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditIndexPatternContainer = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _ = require(".");
var _breadcrumbs = require("../breadcrumbs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EditIndexPatternCont = ({
  ...props
}) => {
  const {
    dataViews,
    setBreadcrumbs,
    notifications
  } = (0, _public.useKibana)().services;
  const [error, setError] = (0, _react.useState)();
  const [indexPattern, setIndexPattern] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    dataViews.get(props.match.params.id).then(ip => {
      setIndexPattern(ip);
      setBreadcrumbs((0, _breadcrumbs.getEditBreadcrumbs)(ip));
    }).catch(err => {
      setError(err);
    });
  }, [dataViews, props.match.params.id, setBreadcrumbs, setError]);
  if (error) {
    const [errorTitle, errorMessage] = [_i18n.i18n.translate('indexPatternManagement.editIndexPattern.couldNotLoadTitle', {
      defaultMessage: 'Unable to load data view'
    }), _i18n.i18n.translate('indexPatternManagement.editIndexPattern.couldNotLoadMessage', {
      defaultMessage: 'The data view with id:{objectId} could not be loaded. Try creating a new one.',
      values: {
        objectId: props.match.params.id
      }
    })];
    notifications.toasts.addError(error !== null && error !== void 0 ? error : new Error(errorTitle), {
      title: errorTitle,
      toastMessage: errorMessage
    });
    props.history.push('/');
  }
  return indexPattern != null ? /*#__PURE__*/_react.default.createElement(_.EditIndexPattern, {
    indexPattern: indexPattern
  }) : null;
};
const EditIndexPatternContainer = (0, _reactRouterDom.withRouter)(EditIndexPatternCont);
exports.EditIndexPatternContainer = EditIndexPatternContainer;