"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditIndexPattern = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-views-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _tabs = require("./tabs");
var _index_header = require("./index_header");
var _utils = require("../utils");
var _remove_data_view = require("./remove_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const codeStyle = {
  marginLeft: '8px'
};
const mappingConflictHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.mappingConflictHeader', {
  defaultMessage: 'Mapping conflict'
});
const securityDataView = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.badge.securityDataViewTitle', {
  defaultMessage: 'Security Data View'
});
const securitySolution = 'security-solution';
const getCompositeRuntimeFields = dataView => (0, _lodash.pickBy)(dataView.getAllRuntimeFields(), fld => fld.type === 'composite');
const EditIndexPattern = (0, _reactRouterDom.withRouter)(({
  indexPattern,
  history,
  location
}) => {
  const {
    uiSettings,
    overlays,
    chrome,
    dataViews,
    IndexPatternEditor,
    savedObjectsManagement
  } = (0, _public2.useKibana)().services;
  const [fields, setFields] = (0, _react.useState)(indexPattern.getNonScriptedFields());
  const [compositeRuntimeFields, setCompositeRuntimeFields] = (0, _react.useState)(() => getCompositeRuntimeFields(indexPattern));
  const [conflictedFields, setConflictedFields] = (0, _react.useState)(indexPattern.fields.getAll().filter(field => field.type === 'conflict'));
  const [defaultIndex, setDefaultIndex] = (0, _react.useState)(uiSettings.get('defaultIndex'));
  const [tags, setTags] = (0, _react.useState)([]);
  const [showEditDialog, setShowEditDialog] = (0, _react.useState)(false);
  const [relationships, setRelationships] = (0, _react.useState)([]);
  const [allowedTypes, setAllowedTypes] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    savedObjectsManagement.getAllowedTypes().then(resp => {
      setAllowedTypes(resp);
    });
  }, [savedObjectsManagement]);
  (0, _react.useEffect)(() => {
    if (allowedTypes.length === 0 || !indexPattern.isPersisted()) {
      return;
    }
    const allowedAsString = allowedTypes.map(item => item.name);
    savedObjectsManagement.getRelationships(_public.DATA_VIEW_SAVED_OBJECT_TYPE, indexPattern.id, allowedAsString).then(resp => {
      setRelationships(resp.relations.map(r => ({
        ...r,
        title: r.meta.title
      })));
    });
  }, [savedObjectsManagement, indexPattern, allowedTypes]);
  (0, _react.useEffect)(() => {
    setFields(indexPattern.getNonScriptedFields());
    setConflictedFields(indexPattern.fields.getAll().filter(field => field.type === 'conflict'));
  }, [indexPattern]);
  (0, _react.useEffect)(() => {
    setTags((0, _utils.getTags)(indexPattern, indexPattern.id === defaultIndex));
  }, [defaultIndex, indexPattern]);
  const setDefaultPattern = (0, _react.useCallback)(() => {
    uiSettings.set('defaultIndex', indexPattern.id);
    setDefaultIndex(indexPattern.id || '');
  }, [uiSettings, indexPattern.id]);
  const removeHandler = (0, _remove_data_view.removeDataView)({
    dataViews,
    uiSettings,
    overlays,
    onDelete: () => {
      history.push('');
    }
  });
  const isRollup = new URLSearchParams((0, _reactRouterDom.useLocation)().search).get('type') === 'rollup';
  const displayIndexPatternEditor = showEditDialog ? /*#__PURE__*/_react.default.createElement(IndexPatternEditor, {
    onSave: () => {
      setFields(indexPattern.getNonScriptedFields());
      setShowEditDialog(false);
    },
    onCancel: () => setShowEditDialog(false),
    defaultTypeIsRollup: isRollup,
    editData: indexPattern
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const editPattern = () => {
    setShowEditDialog(true);
  };
  const indexPatternHeading = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.indexPatternHeading', {
    defaultMessage: 'Index pattern:'
  });
  const timeFilterHeading = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.timeFilterHeading', {
    defaultMessage: 'Time field:'
  });
  const mappingConflictLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.mappingConflictLabel', {
    defaultMessage: '{conflictFieldsLength, plural, one {A field is} other {# fields are}} defined as several types (string, integer, etc) across the indices that match this pattern. You may still be able to use these conflict fields in parts of Kibana, but they will be unavailable for functions that require Kibana to know their type. Correcting this issue will require reindexing your data.',
    values: {
      conflictFieldsLength: conflictedFields.length
    }
  });
  const headingAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.detailsAria', {
    defaultMessage: 'Data view details'
  });
  chrome.docTitle.change(indexPattern.getName());
  const userEditPermission = dataViews.getCanSaveSync();
  const warning = indexPattern.namespaces && indexPattern.namespaces.length > 1 || indexPattern.namespaces.includes('*') ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editDataView.deleteWarningWithNamespaces",
    defaultMessage: "Delete the data view {dataViewName} from every space it is shared in. You can't undo this action.",
    values: {
      dataViewName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, indexPattern.getName())
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.editDataView.deleteWarning",
    defaultMessage: "The data view {dataViewName} will be deleted. You can't undo this action.",
    values: {
      dataViewName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, indexPattern.getName())
    }
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "editIndexPattern",
    role: "region",
    "aria-label": headingAriaLabel
  }, /*#__PURE__*/_react.default.createElement(_index_header.IndexHeader, {
    indexPattern: indexPattern,
    setDefault: setDefaultPattern,
    editIndexPatternClick: editPattern,
    deleteIndexPatternClick: () => removeHandler([indexPattern], /*#__PURE__*/_react.default.createElement("div", null, warning)),
    defaultIndex: defaultIndex,
    canSave: userEditPermission
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "l",
    alignItems: "center"
  }, Boolean(indexPattern.title) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, indexPatternHeading), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "currentIndexPatternTitle",
    style: codeStyle
  }, indexPattern.title))), Boolean(indexPattern.timeFieldName) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, timeFilterHeading), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "currentIndexPatternTimeField",
    style: codeStyle
  }, indexPattern.timeFieldName))), indexPattern.id && indexPattern.id.indexOf(securitySolution) === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, securityDataView)), tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: tag.key
  }, tag.key === 'default' ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "starFilled",
    color: "default"
  }, tag.name) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, tag.name)))), conflictedFields.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: mappingConflictHeader,
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, mappingConflictLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    indexPattern: indexPattern,
    saveIndexPattern: dataViews.updateSavedObject.bind(dataViews),
    fields: fields,
    relationships: relationships,
    allowedTypes: allowedTypes,
    history: history,
    location: location,
    compositeRuntimeFields: compositeRuntimeFields,
    refreshFields: () => {
      setFields(indexPattern.getNonScriptedFields());
      setCompositeRuntimeFields(getCompositeRuntimeFields(indexPattern));
    }
  }), displayIndexPatternEditor);
});
exports.EditIndexPattern = EditIndexPattern;