"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditFieldContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _breadcrumbs = require("../../breadcrumbs");
var _create_edit_field = require("./create_edit_field");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CreateEditFieldCont = ({
  ...props
}) => {
  const {
    setBreadcrumbs,
    dataViews
  } = (0, _public.useKibana)().services;
  const [indexPattern, setIndexPattern] = (0, _react.useState)();
  const fieldName = props.match.params.fieldName && decodeURIComponent(props.match.params.fieldName);
  (0, _react.useEffect)(() => {
    dataViews.get(props.match.params.id).then(ip => {
      setIndexPattern(ip);
      if (ip) {
        setBreadcrumbs(fieldName ? (0, _breadcrumbs.getEditFieldBreadcrumbs)(ip, fieldName) : (0, _breadcrumbs.getCreateFieldBreadcrumbs)(ip));
      }
    });
  }, [props.match.params.id, fieldName, setBreadcrumbs, dataViews]);
  if (indexPattern) {
    return /*#__PURE__*/_react.default.createElement(_create_edit_field.CreateEditField, {
      indexPattern: indexPattern,
      mode: fieldName ? 'edit' : 'create',
      fieldName: fieldName
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
};
const CreateEditFieldContainer = (0, _reactRouterDom.withRouter)(CreateEditFieldCont);
exports.CreateEditFieldContainer = CreateEditFieldContainer;