"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatEditorService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _field_format_editors = require("./field_format_editors");
var _components = require("../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Index patterns management service
 *
 * @internal
 */
class FormatEditorService {
  constructor() {
    (0, _defineProperty2.default)(this, "fieldFormatEditors", void 0);
    this.fieldFormatEditors = new _field_format_editors.FieldFormatEditors();
  }
  setup() {
    const defaultFieldFormatEditorFactories = [_components.bytesFormatEditorFactory, _components.colorFormatEditorFactory, _components.dateFormatEditorFactory, _components.dateNanosFormatEditorFactory, _components.durationFormatEditorFactory, _components.geoPointFormatEditorFactory, _components.numberFormatEditorFactory, _components.percentFormatEditorFactory, _components.staticLookupFormatEditorFactory, _components.stringFormatEditorFactory, _components.truncateFormatEditorFactory, _components.urlFormatEditorFactory, _components.histogramFormatEditorFactory];
    const fieldFormatEditorsSetup = this.fieldFormatEditors.setup(defaultFieldFormatEditorFactories);
    return {
      fieldFormatEditors: fieldFormatEditorsSetup
    };
  }
  start() {
    return {
      fieldFormatEditors: this.fieldFormatEditors.start()
    };
  }
  stop() {
    // nothing to do here yet.
  }
}

/** @internal */
exports.FormatEditorService = FormatEditorService;