"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultValueFormatter = exports.PreviewController = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _fieldTypes = require("@kbn/field-types");
var _server = require("react-dom/server");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultValueFormatter = value => {
  var _String;
  const content = typeof value === 'object' ? JSON.stringify(value) : (_String = String(value)) !== null && _String !== void 0 ? _String : '-';
  return (0, _server.renderToString)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content));
};
exports.defaultValueFormatter = defaultValueFormatter;
const previewStateDefault = {
  /** Map of fields pinned to the top of the list */
  pinnedFields: {},
  isLoadingDocuments: true,
  /** Flag to indicate if we are loading a single document by providing its ID */
  customId: undefined,
  /** sample documents fetched from cluster */
  documents: [],
  currentIdx: 0,
  documentSource: 'cluster',
  /** Keep track if the script painless syntax is being validated and if it is valid  */
  scriptEditorValidation: {
    isValidating: false,
    isValid: true,
    message: null
  },
  previewResponse: {
    fields: [],
    error: null
  }
};
class PreviewController {
  constructor({
    dataView,
    search,
    fieldFormats
  }) {
    // dependencies
    // @ts-ignore
    (0, _defineProperty2.default)(this, "dataView", void 0);
    // @ts-ignore
    (0, _defineProperty2.default)(this, "search", void 0);
    (0, _defineProperty2.default)(this, "fieldFormats", void 0);
    (0, _defineProperty2.default)(this, "internalState$", void 0);
    (0, _defineProperty2.default)(this, "state$", void 0);
    (0, _defineProperty2.default)(this, "updateState", newState => {
      this.internalState$.next({
        ...this.state$.getValue(),
        ...newState
      });
    });
    (0, _defineProperty2.default)(this, "togglePinnedField", fieldName => {
      const currentState = this.state$.getValue();
      const pinnedFields = {
        ...currentState.pinnedFields,
        [fieldName]: !currentState.pinnedFields[fieldName]
      };
      this.updateState({
        pinnedFields
      });
    });
    (0, _defineProperty2.default)(this, "setDocuments", documents => {
      this.updateState({
        documents,
        currentIdx: 0,
        isLoadingDocuments: false
      });
    });
    (0, _defineProperty2.default)(this, "setCurrentIdx", currentIdx => {
      this.updateState({
        currentIdx
      });
    });
    (0, _defineProperty2.default)(this, "goToNextDocument", () => {
      const currentState = this.state$.getValue();
      if (currentState.currentIdx >= currentState.documents.length - 1) {
        this.updateState({
          currentIdx: 0
        });
      } else {
        this.updateState({
          currentIdx: currentState.currentIdx + 1
        });
      }
    });
    (0, _defineProperty2.default)(this, "goToPreviousDocument", () => {
      const currentState = this.state$.getValue();
      if (currentState.currentIdx === 0) {
        this.updateState({
          currentIdx: currentState.documents.length - 1
        });
      } else {
        this.updateState({
          currentIdx: currentState.currentIdx - 1
        });
      }
    });
    /* disabled while investigating issues with painless script editor
    setScriptEditorValidation = (scriptEditorValidation: PreviewState['scriptEditorValidation']) => {
      this.updateState({ scriptEditorValidation });
    };
    */
    (0, _defineProperty2.default)(this, "setCustomId", customId => {
      this.updateState({
        customId
      });
    });
    (0, _defineProperty2.default)(this, "setPreviewError", error => {
      this.updateState({
        previewResponse: {
          ...this.internalState$.getValue().previewResponse,
          error
        }
      });
    });
    (0, _defineProperty2.default)(this, "setPreviewResponse", previewResponse => {
      this.updateState({
        previewResponse
      });
    });
    (0, _defineProperty2.default)(this, "clearPreviewError", errorCode => {
      var _prev$error;
      const {
        previewResponse: prev
      } = this.internalState$.getValue();
      const error = prev.error === null || ((_prev$error = prev.error) === null || _prev$error === void 0 ? void 0 : _prev$error.code) === errorCode ? null : prev.error;
      this.updateState({
        previewResponse: {
          ...prev,
          error
        }
      });
    });
    (0, _defineProperty2.default)(this, "valueFormatter", ({
      value,
      format,
      type
    }) => {
      if (format !== null && format !== void 0 && format.id) {
        const formatter = this.fieldFormats.getInstance(format.id, format.params);
        if (formatter) {
          var _formatter$getConvert;
          return (_formatter$getConvert = formatter.getConverterFor('html')(value)) !== null && _formatter$getConvert !== void 0 ? _formatter$getConvert : JSON.stringify(value);
        }
      }
      if (type) {
        const fieldType = (0, _fieldTypes.castEsToKbnFieldTypeName)(type);
        const defaultFormatterForType = this.fieldFormats.getDefaultInstance(fieldType);
        if (defaultFormatterForType) {
          var _defaultFormatterForT;
          return (_defaultFormatterForT = defaultFormatterForType.getConverterFor('html')(value)) !== null && _defaultFormatterForT !== void 0 ? _defaultFormatterForT : JSON.stringify(value);
        }
      }
      return defaultValueFormatter(value);
    });
    this.dataView = dataView;
    this.search = search;
    this.fieldFormats = fieldFormats;
    this.internalState$ = new _rxjs.BehaviorSubject({
      ...previewStateDefault
    });
    this.state$ = this.internalState$;
  }
}
exports.PreviewController = PreviewController;