"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueTypeToSelectedType = exports.useFieldPreviewContext = exports.defaultValueFormatter = exports.FieldPreviewProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _server = require("react-dom/server");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _state_utils = require("../../state_utils");
var _runtime_field_validation = require("../../lib/runtime_field_validation");
var _field_editor_context = require("../field_editor_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const fieldPreviewContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const defaultParams = {
  name: null,
  index: null,
  script: null,
  document: null,
  type: null,
  format: null,
  parentName: null
};
const defaultValueFormatter = value => {
  var _String;
  const content = typeof value === 'object' ? JSON.stringify(value) : (_String = String(value)) !== null && _String !== void 0 ? _String : '-';
  return (0, _server.renderToString)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, content));
};
exports.defaultValueFormatter = defaultValueFormatter;
const valueTypeToSelectedType = value => {
  const valueType = typeof value;
  if (valueType === 'string') return 'keyword';
  if (valueType === 'number') return 'double';
  if (valueType === 'boolean') return 'boolean';
  return 'keyword';
};
exports.valueTypeToSelectedType = valueTypeToSelectedType;
const documentsSelector = state => {
  const currentDocument = state.documents[state.currentIdx];
  return {
    currentDocument,
    totalDocs: state.documents.length,
    currentDocIndex: currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument._index,
    currentDocId: currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument._id,
    currentIdx: state.currentIdx
  };
};
const FieldPreviewProvider = ({
  controller,
  children
}) => {
  const previewCount = (0, _react.useRef)(0);

  // We keep in cache the latest params sent to the _execute API so we don't make unecessary requests
  // when changing parameters that don't affect the preview result (e.g. changing the "name" field).
  const lastExecutePainlessRequestParams = (0, _react.useRef)({
    type: null,
    script: undefined,
    documentId: undefined
  });
  const {
    dataView,
    fieldTypeToProcess,
    services: {
      search,
      notifications,
      api: {
        getFieldPreview
      }
    },
    fieldName$
  } = (0, _field_editor_context.useFieldEditorContext)();
  const fieldPreview$ = (0, _react.useRef)(new _rxjs.BehaviorSubject(undefined));
  const [initialPreviewComplete, setInitialPreviewComplete] = (0, _react.useState)(false);

  /** Possible error while fetching sample documents */
  const [fetchDocError, setFetchDocError] = (0, _react.useState)(null);
  /** The parameters required for the Painless _execute API */
  const [params, setParams] = (0, _react.useState)(defaultParams);
  const [scriptEditorValidation, setScriptEditorValidation] = (0, _react.useState)({
    isValidating: false,
    isValid: true,
    message: null
  });

  /** Flag to show/hide the preview panel */
  const [isPanelVisible, setIsPanelVisible] = (0, _react.useState)(true);
  /** Flag to indicate if we are loading document from cluster */
  const [isFetchingDocument, setIsFetchingDocument] = (0, _react.useState)(false);
  /** Flag to indicate if we are calling the _execute API */
  const [isLoadingPreview, setIsLoadingPreview] = (0, _react.useState)(false);

  /** Flag to indicate if we are loading a single document by providing its ID */
  const [customDocIdToLoad, setCustomDocIdToLoad] = (0, _react.useState)(null);
  const {
    currentDocument,
    currentDocIndex,
    currentDocId,
    totalDocs,
    currentIdx
  } = (0, _state_utils.useStateSelector)(controller.state$, documentsSelector);
  let isPreviewAvailable = true;

  // If no documents could be fetched from the cluster (and we are not trying to load
  // a custom doc ID) then we disable preview as the script field validation expect the result
  // of the preview to before resolving. If there are no documents we can't have a preview
  // (the _execute API expects one) and thus the validation should not expect a value.
  if (!isFetchingDocument && !customDocIdToLoad && totalDocs === 0) {
    isPreviewAvailable = false;
  }
  const {
    name,
    document,
    script,
    format,
    type,
    parentName
  } = params;
  const updateParams = (0, _react.useCallback)(updated => {
    setParams(prev => ({
      ...prev,
      ...updated
    }));
  }, []);
  const allParamsDefined = (0, _react.useMemo)(() => {
    if (!currentDocIndex || !(script !== null && script !== void 0 && script.source) || !type) {
      return false;
    }
    return true;
  }, [currentDocIndex, script === null || script === void 0 ? void 0 : script.source, type]);
  const hasSomeParamsChanged = (0, _react.useMemo)(() => {
    return lastExecutePainlessRequestParams.current.type !== type || lastExecutePainlessRequestParams.current.script !== (script === null || script === void 0 ? void 0 : script.source) || lastExecutePainlessRequestParams.current.documentId !== currentDocId;
  }, [type, script, currentDocId]);
  const fetchSampleDocuments = (0, _react.useCallback)(async (limit = 50) => {
    if (typeof limit !== 'number') {
      // We guard ourself from passing an <input /> event accidentally
      throw new Error('The "limit" option must be a number');
    }
    lastExecutePainlessRequestParams.current.documentId = undefined;
    setIsFetchingDocument(true);
    controller.setPreviewResponse({
      fields: [],
      error: null
    });
    const [response, searchError] = await search.search({
      params: {
        index: dataView.getIndexPattern(),
        body: {
          fields: ['*'],
          size: limit
        }
      }
    }).toPromise().then(res => [res, null]).catch(err => [null, err]);
    setIsFetchingDocument(false);
    setCustomDocIdToLoad(null);
    const error = Boolean(searchError) ? {
      code: 'ERR_FETCHING_DOC',
      error: {
        message: searchError.toString(),
        reason: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.error.errorLoadingSampleDocumentsDescription', {
          defaultMessage: 'Error loading sample documents.'
        })
      }
    } : null;
    setFetchDocError(error);
    if (error === null) {
      controller.setDocuments(response ? response.rawResponse.hits.hits : []);
    }
  }, [dataView, search, controller]);
  const loadDocument = (0, _react.useCallback)(async id => {
    if (!Boolean(id.trim())) {
      return;
    }
    lastExecutePainlessRequestParams.current.documentId = undefined;
    setIsFetchingDocument(true);
    const [response, searchError] = await search.search({
      params: {
        index: dataView.getIndexPattern(),
        body: {
          size: 1,
          fields: ['*'],
          query: {
            ids: {
              values: [id]
            }
          }
        }
      }
    }).toPromise().then(res => [res, null]).catch(err => [null, err]);
    setIsFetchingDocument(false);
    const isDocumentFound = (response === null || response === void 0 ? void 0 : response.rawResponse.hits.total) > 0;
    const loadedDocuments = isDocumentFound ? response.rawResponse.hits.hits : [];
    const error = Boolean(searchError) ? {
      code: 'ERR_FETCHING_DOC',
      error: {
        message: searchError.toString(),
        reason: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.error.errorLoadingDocumentDescription', {
          defaultMessage: 'Error loading document.'
        })
      }
    } : isDocumentFound === false ? {
      code: 'DOC_NOT_FOUND',
      error: {
        message: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.error.documentNotFoundDescription', {
          defaultMessage: 'Document ID not found'
        })
      }
    } : null;
    setFetchDocError(error);
    if (error === null) {
      controller.setDocuments(loadedDocuments);
    } else {
      // Make sure we disable the "Updating..." indicator as we have an error
      // and we won't fetch the preview
      setIsLoadingPreview(false);
    }
  }, [dataView, search, controller]);
  const updateSingleFieldPreview = (0, _react.useCallback)((fieldName, values) => {
    const [value] = values;
    const formattedValue = controller.valueFormatter({
      value,
      type,
      format
    });
    controller.setPreviewResponse({
      fields: [{
        key: fieldName,
        value,
        formattedValue
      }],
      error: null
    });
  }, [controller, type, format]);
  const updateCompositeFieldPreview = (0, _react.useCallback)(compositeValues => {
    const updatedFieldsInScript = [];
    // if we're displaying a composite subfield, filter results
    const filterSubfield = parentName ? field => field.key === name : () => true;
    const fields = Object.entries(compositeValues).map(([key, values]) => {
      var _fieldName$$getValue;
      // The Painless _execute API returns the composite field values under a map.
      // Each of the key is prefixed with "composite_field." (e.g. "composite_field.field1: ['value']")
      const {
        1: fieldName
      } = key.split('composite_field.');
      updatedFieldsInScript.push(fieldName);
      const [value] = values;
      const formattedValue = controller.valueFormatter({
        value,
        type,
        format
      });
      return {
        key: parentName ? `${parentName !== null && parentName !== void 0 ? parentName : ''}.${fieldName}` : `${(_fieldName$$getValue = fieldName$.getValue()) !== null && _fieldName$$getValue !== void 0 ? _fieldName$$getValue : ''}.${fieldName}`,
        value,
        formattedValue,
        type: valueTypeToSelectedType(value)
      };
    }).filter(filterSubfield)
    // ...and sort alphabetically
    .sort((a, b) => a.key.localeCompare(b.key));
    fieldPreview$.current.next(fields);
    controller.setPreviewResponse({
      fields,
      error: null
    });
  }, [parentName, name, fieldPreview$, fieldName$, controller, type, format]);
  const updatePreview = (0, _react.useCallback)(async () => {
    var _dataView$getRuntimeF;
    // don't prevent rendering if we're working with a composite subfield (has parentName)
    if (!parentName && scriptEditorValidation.isValidating) {
      return;
    }
    if (!parentName && (!allParamsDefined || !hasSomeParamsChanged || scriptEditorValidation.isValid === false)) {
      setIsLoadingPreview(false);
      return;
    }
    lastExecutePainlessRequestParams.current = {
      type,
      script: script === null || script === void 0 ? void 0 : script.source,
      documentId: currentDocId
    };
    const currentApiCall = ++previewCount.current;
    const previewScript = parentName && ((_dataView$getRuntimeF = dataView.getRuntimeField(parentName)) === null || _dataView$getRuntimeF === void 0 ? void 0 : _dataView$getRuntimeF.script) || script;
    const response = await getFieldPreview({
      index: currentDocIndex,
      document: document === null || document === void 0 ? void 0 : document._source,
      context: parentName ? 'composite_field' : `${type}_field`,
      script: previewScript
    });
    if (currentApiCall !== previewCount.current) {
      // Discard this response as there is another one inflight
      // or we have called reset() and no longer need the response.
      return;
    }
    const {
      error: serverError
    } = response;
    if (serverError) {
      // Server error (not an ES error)
      const title = _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.errorTitle', {
        defaultMessage: 'Failed to load field preview'
      });
      notifications.toasts.addError(serverError, {
        title
      });
      setIsLoadingPreview(false);
      return;
    }
    if (response.data) {
      const {
        values,
        error
      } = response.data;
      if (error) {
        controller.setPreviewResponse({
          fields: [{
            key: name !== null && name !== void 0 ? name : '',
            value: '',
            formattedValue: defaultValueFormatter('')
          }],
          error: {
            code: 'PAINLESS_SCRIPT_ERROR',
            error: (0, _runtime_field_validation.parseEsError)(error)
          }
        });
      } else {
        if (!Array.isArray(values)) {
          updateCompositeFieldPreview(values);
        } else {
          updateSingleFieldPreview(name, values);
        }
      }
    }
    setInitialPreviewComplete(true);
    setIsLoadingPreview(false);
  }, [name, type, script, parentName, dataView, document, currentDocId, getFieldPreview, notifications.toasts, allParamsDefined, scriptEditorValidation, hasSomeParamsChanged, updateSingleFieldPreview, updateCompositeFieldPreview, currentDocIndex, controller]);
  const reset = (0, _react.useCallback)(() => {
    // By resetting the previewCount we will discard previous inflight
    // API call response coming in after calling reset() was called
    previewCount.current = 0;
    controller.setDocuments([]);
    controller.setPreviewResponse({
      fields: [],
      error: null
    });
    setIsLoadingPreview(false);
    setIsFetchingDocument(false);
  }, [controller]);
  const ctx = (0, _react.useMemo)(() => ({
    controller,
    fieldPreview$: fieldPreview$.current,
    isPreviewAvailable,
    isLoadingPreview,
    initialPreviewComplete,
    params: {
      value: params,
      update: updateParams
    },
    documents: {
      loadSingle: setCustomDocIdToLoad,
      loadFromCluster: fetchSampleDocuments,
      fetchDocError
    },
    navigation: {
      isFirstDoc: currentIdx === 0,
      isLastDoc: currentIdx >= totalDocs - 1
    },
    panel: {
      isVisible: isPanelVisible,
      setIsVisible: setIsPanelVisible
    },
    validation: {
      setScriptEditorValidation
    },
    reset
  }), [controller, currentIdx, fieldPreview$, fetchDocError, params, isPreviewAvailable, isLoadingPreview, updateParams, fetchSampleDocuments, totalDocs, isPanelVisible, reset, initialPreviewComplete]);

  /**
   * In order to immediately display the "Updating..." state indicator and not have to wait
   * the 500ms of the debounce, we set the isLoadingPreview state in this effect whenever
   * one of the _execute API param changes
   */
  (0, _react.useEffect)(() => {
    if (allParamsDefined && hasSomeParamsChanged) {
      setIsLoadingPreview(true);
    }
  }, [allParamsDefined, hasSomeParamsChanged, script === null || script === void 0 ? void 0 : script.source, type, currentDocId]);

  /**
   * In order to immediately display the "Updating..." state indicator and not have to wait
   * the 500ms of the debounce, we set the isFetchingDocument state in this effect whenever
   * "customDocIdToLoad" changes
   */
  (0, _react.useEffect)(() => {
    controller.setCustomId(customDocIdToLoad || undefined);
    if (customDocIdToLoad !== null && Boolean(customDocIdToLoad.trim())) {
      setIsFetchingDocument(true);
    }
  }, [customDocIdToLoad, controller]);

  /**
   * Whenever we show the preview panel we will update the documents from the cluster
   */
  (0, _react.useEffect)(() => {
    if (isPanelVisible) {
      fetchSampleDocuments();
    }
  }, [isPanelVisible, fetchSampleDocuments, fieldTypeToProcess]);

  /**
   * Each time the current document changes we update the parameters
   * that will be sent in the _execute HTTP request.
   */
  (0, _react.useEffect)(() => {
    updateParams({
      document: currentDocument,
      index: currentDocument === null || currentDocument === void 0 ? void 0 : currentDocument._index
    });
  }, [currentDocument, updateParams]);

  /**
   * Whenever the name or the format changes we immediately update the preview
   */
  (0, _react.useEffect)(() => {
    const {
      previewResponse: prev
    } = controller.state$.getValue();
    const {
      fields
    } = prev;
    let updatedFields = fields.map(field => {
      let key = name !== null && name !== void 0 ? name : '';
      if (type === 'composite') {
        // restore initial key segement (the parent name), which was not returned
        const {
          1: fieldName
        } = field.key.split('.');
        key = `${name !== null && name !== void 0 ? name : ''}.${fieldName}`;
      }
      return {
        ...field,
        key
      };
    });

    // If the user has entered a name but not yet any script we will display
    // the field in the preview with just the name
    if (updatedFields.length === 0 && name !== null) {
      updatedFields = [{
        key: name,
        value: undefined,
        formattedValue: undefined,
        type: undefined
      }];
    }
    controller.setPreviewResponse({
      ...prev,
      fields: updatedFields
    });
  }, [name, type, parentName, controller]);

  /**
   * Whenever the format changes we immediately update the preview
   */
  (0, _react.useEffect)(() => {
    const {
      previewResponse: prev
    } = controller.state$.getValue();
    const {
      fields
    } = prev;
    controller.setPreviewResponse({
      ...prev,
      fields: fields.map(field => {
        var _get;
        const nextValue = script === null && Boolean(document) ? (_get = (0, _lodash.get)(document === null || document === void 0 ? void 0 : document._source, name !== null && name !== void 0 ? name : '')) !== null && _get !== void 0 ? _get : (0, _lodash.get)(document === null || document === void 0 ? void 0 : document.fields, name !== null && name !== void 0 ? name : '') // When there is no script we try to read the value from _source/fields
        : field === null || field === void 0 ? void 0 : field.value;
        const formattedValue = controller.valueFormatter({
          value: nextValue,
          type,
          format
        });
        return {
          ...field,
          value: nextValue,
          formattedValue
        };
      })
    });
  }, [name, script, document, controller, type, format]);
  (0, _react.useEffect)(() => {
    if ((script === null || script === void 0 ? void 0 : script.source) === undefined) {
      // Whenever the source is not defined ("Set value" is toggled off or the
      // script is empty) we clear the error and update the params cache.
      lastExecutePainlessRequestParams.current.script = undefined;
      controller.setPreviewError(null);
    }
  }, [script === null || script === void 0 ? void 0 : script.source, controller]);

  // Handle the validation state coming from the Painless DiagnosticAdapter
  // (see @kbn-monaco/src/painless/diagnostics_adapter.ts)
  (0, _react.useEffect)(() => {
    if (scriptEditorValidation.isValidating) {
      return;
    }
    if (scriptEditorValidation.isValid === false) {
      var _scriptEditorValidati;
      // Make sure to remove the "Updating..." spinner
      setIsLoadingPreview(false);

      // Set preview response error so it is displayed in the flyout footer
      const error = (script === null || script === void 0 ? void 0 : script.source) === undefined ? null : {
        code: 'PAINLESS_SYNTAX_ERROR',
        error: {
          reason: (_scriptEditorValidati = scriptEditorValidation.message) !== null && _scriptEditorValidati !== void 0 ? _scriptEditorValidati : _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.error.painlessSyntax', {
            defaultMessage: 'Invalid Painless syntax'
          })
        }
      };
      controller.setPreviewError(error);

      // Make sure to update the lastExecutePainlessRequestParams cache so when the user updates
      // the script and fixes the syntax the "updatePreview()" will run
      lastExecutePainlessRequestParams.current.script = script === null || script === void 0 ? void 0 : script.source;
    } else {
      // Clear possible previous syntax error
      controller.clearPreviewError('PAINLESS_SYNTAX_ERROR');
    }
  }, [scriptEditorValidation, script === null || script === void 0 ? void 0 : script.source, controller]);

  /**
   * Whenever updatePreview() changes (meaning whenever a param changes)
   * we call it to update the preview response with the field(s) value or possible error.
   */
  (0, _useDebounce.default)(updatePreview, 500, [updatePreview]);

  /**
   * Whenever the doc ID to load changes we load the document (after a 500ms debounce)
   */
  (0, _useDebounce.default)(() => {
    if (customDocIdToLoad === null) {
      return;
    }
    loadDocument(customDocIdToLoad);
  }, 500, [customDocIdToLoad]);
  return /*#__PURE__*/_react.default.createElement(fieldPreviewContext.Provider, {
    value: ctx
  }, children);
};
exports.FieldPreviewProvider = FieldPreviewProvider;
const useFieldPreviewContext = () => {
  const ctx = (0, _react.useContext)(fieldPreviewContext);
  if (ctx === undefined) {
    throw new Error('useFieldPreviewContext must be used within a <FieldPreviewProvider />');
  }
  return ctx;
};
exports.useFieldPreviewContext = useFieldPreviewContext;