"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _field_preview_context = require("./field_preview_context");
var _field_preview_header = require("./field_preview_header");
var _field_preview_empty_prompt = require("./field_preview_empty_prompt");
var _documents_nav_preview = require("./documents_nav_preview");
var _field_preview_error = require("./field_preview_error");
var _field_list_item = require("./field_list/field_list_item");
var _field_list = require("./field_list/field_list");
var _state_utils = require("../../state_utils");
require("./field_preview.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldPreview = () => {
  const [fieldListHeight, setFieldListHeight] = (0, _react.useState)(-1);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    params: {
      value: {
        name,
        script,
        format
      }
    },
    isLoadingPreview,
    documents: {
      fetchDocError
    },
    reset,
    isPreviewAvailable,
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const {
    fields,
    error
  } = (0, _state_utils.useStateSelector)(controller.state$, state => state.previewResponse);

  // To show the preview we at least need a name to be defined, the script or the format
  // and an first response from the _execute API
  let isEmptyPromptVisible = false;
  const noParamDefined = name === null && script === null && format === null;
  const haveResultFromPreview = error !== null || fields.length > 0;
  if (noParamDefined) {
    isEmptyPromptVisible = true;
  } else if (!haveResultFromPreview && !isLoadingPreview && name === null && format === null) {
    isEmptyPromptVisible = true;
  }
  const doRenderListOfFields = fetchDocError === null;
  const showWarningPreviewNotAvailable = isPreviewAvailable === false && fetchDocError === null;
  const onFieldListResize = (0, _react.useCallback)(({
    height
  }) => {
    setFieldListHeight(height);
  }, []);
  const renderFieldsToPreview = () => {
    if (fields.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("ul", null, fields.map((field, i) => /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      "data-test-subj": "fieldPreviewItem"
    }, /*#__PURE__*/_react.default.createElement(_field_list_item.PreviewListItem, {
      field: field,
      isFromScript: true,
      hasScriptError: Boolean(error)
    }))));
  };
  (0, _react.useEffect)(() => {
    // When unmounting the preview pannel we make sure to reset
    // the state of the preview panel.
    return reset;
  }, [reset]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "indexPatternFieldEditor__previewPannel"
    // This tabIndex is for the scrollable area of the flyout panel.
    ,
    tabIndex: 0
  }, isEmptyPromptVisible ? /*#__PURE__*/_react.default.createElement(_field_preview_empty_prompt.FieldPreviewEmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_preview_header.FieldPreviewHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), showWarningPreviewNotAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.notAvailableWarningCallout.title', {
      defaultMessage: 'Preview not available'
    }),
    color: "warning",
    iconType: "warning",
    role: "alert",
    "data-test-subj": "previewNotAvailableCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.notAvailableWarningCallout.description', {
    defaultMessage: 'Runtime field preview is disabled because no documents could be fetched from the cluster.'
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_documents_nav_preview.DocumentsNavPreview, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), doRenderListOfFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchValue,
    onChange: e => setSearchValue(e.target.value),
    placeholder: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.filterFieldsPlaceholder', {
      defaultMessage: 'Filter fields'
    }),
    fullWidth: true,
    "data-test-subj": "filterFieldsInput"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_field_preview_error.FieldPreviewError, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), doRenderListOfFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderFieldsToPreview(), /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onFieldListResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    style: {
      flex: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_field_list.PreviewFieldList, {
    height: fieldListHeight,
    clearSearch: () => setSearchValue(''),
    searchValue: searchValue
    // We add a key to force rerender the virtual list whenever the window height changes
    ,
    key: fieldListHeight
  })))))));
};
exports.FieldPreview = FieldPreview;